/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property;

import com.netflix.config.Property;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public abstract class DynamicProperty<T> {
    protected final Property<T> dynamicProperty;

    DynamicProperty(Property<T> dynamicProperty) {
        this.dynamicProperty = dynamicProperty;
    }

    public abstract T get();

    public void addCallback(Runnable callback) {
        if (callback != null) {
            this.dynamicProperty.addCallback(callback);
        }
    }

    public void removeAllCallbacks() {
        this.dynamicProperty.removeAllCallbacks();
    }

    protected static void stripBrackets(Collection<String> unStripped, Collection<String> stripped) {
        for (String item : unStripped) {
            String itemStripped = StringUtils.strip((String)item, (String)"[]");
            stripped.add(itemStripped);
        }
    }

    public String toString() {
        return this.dynamicProperty.toString();
    }
}

