/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property;

import com.netflix.config.PropertyWrapper;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicEnumProperty<E extends Enum>
extends PropertyWrapper<E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicEnumProperty.class);

    public DynamicEnumProperty(String propName, E defaultValue) {
        super(propName, defaultValue);
    }

    public E get() {
        String strEnum = this.prop.getString(this.defaultValue == null ? null : ((Enum)this.defaultValue).name());
        if (strEnum == null) {
            return null;
        }
        try {
            return (E)Enum.valueOf(((Enum)this.defaultValue).getClass(), strEnum.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            log.warn("Invalid enum: class=[{}], value=[{}]", ((Enum)this.defaultValue).getClass(), (Object)strEnum.toUpperCase());
            return (E)((Enum)this.defaultValue);
        }
    }

    public E getValue() {
        return this.get();
    }
}

