/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property;

import com.appdynamics.common.util.configuration.property.DynamicBoolean;
import com.appdynamics.common.util.configuration.property.DynamicDouble;
import com.appdynamics.common.util.configuration.property.DynamicEnum;
import com.appdynamics.common.util.configuration.property.DynamicEnumProperty;
import com.appdynamics.common.util.configuration.property.DynamicFloat;
import com.appdynamics.common.util.configuration.property.DynamicInt;
import com.appdynamics.common.util.configuration.property.DynamicIntegerListProperty;
import com.appdynamics.common.util.configuration.property.DynamicList;
import com.appdynamics.common.util.configuration.property.DynamicListString;
import com.appdynamics.common.util.configuration.property.DynamicLong;
import com.appdynamics.common.util.configuration.property.DynamicLongListProperty;
import com.appdynamics.common.util.configuration.property.DynamicProperty;
import com.appdynamics.common.util.configuration.property.DynamicSet;
import com.appdynamics.common.util.configuration.property.DynamicSetString;
import com.appdynamics.common.util.configuration.property.DynamicString;
import com.appdynamics.common.util.configuration.property.DynamicTimeUnitConfiguration;
import com.appdynamics.common.util.configuration.property.DynamicTimeUnitConfigurationProperty;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.lifecycle.Stoppable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicListProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicSetProperty;
import com.netflix.config.DynamicStringListProperty;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.DynamicStringSetProperty;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProperties
implements Closeable,
Stoppable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationProperties.class);
    public static final String DEFAULT_LIST_DELIMITER = ",";
    private final DynamicPropertyFactory dynamicPropertyFactory;
    private final ConcurrentHashMap<String, DynamicProperty<?>> allDynamicProperties;

    public ConfigurationProperties(DynamicPropertyFactory dynamicPropertyFactory) {
        Preconditions.checkNotNull((Object)dynamicPropertyFactory, (Object)"dynamicPropertyFactory can't be null");
        this.dynamicPropertyFactory = dynamicPropertyFactory;
        this.allDynamicProperties = new ConcurrentHashMap();
    }

    public String getString(String propName, @Nullable String defaultValue) {
        this.validatePropertyName(propName);
        return this.dynamicPropertyFactory.getStringProperty(propName, defaultValue, null).get();
    }

    public DynamicString getDynamicString(String propName, @Nullable String defaultValue) {
        return this.getDynamicString(propName, defaultValue, null);
    }

    public DynamicString getDynamicString(String propName, @Nullable String defaultValue, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        DynamicStringProperty dynamicProperty = this.dynamicPropertyFactory.getStringProperty(propName, defaultValue, propertyChangeCallback);
        DynamicString dynamicString = new DynamicString(dynamicProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicString);
        return dynamicString;
    }

    public boolean getBoolean(String propName, boolean defaultValue) {
        this.validatePropertyName(propName);
        return this.dynamicPropertyFactory.getBooleanProperty(propName, defaultValue, null).get();
    }

    public DynamicBoolean getDynamicBoolean(String propName, boolean defaultValue) {
        return this.getDynamicBoolean(propName, defaultValue, null);
    }

    public DynamicBoolean getDynamicBoolean(String propName, boolean defaultValue, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        DynamicBooleanProperty dynamicProperty = this.dynamicPropertyFactory.getBooleanProperty(propName, defaultValue, propertyChangeCallback);
        DynamicBoolean dynamicBoolean = new DynamicBoolean(dynamicProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicBoolean);
        return dynamicBoolean;
    }

    public double getDouble(String propName, double defaultValue) {
        this.validatePropertyName(propName);
        return this.dynamicPropertyFactory.getDoubleProperty(propName, defaultValue, null).get();
    }

    public DynamicDouble getDynamicDouble(String propName, double defaultValue) {
        return this.getDynamicDouble(propName, defaultValue, null);
    }

    public DynamicDouble getDynamicDouble(String propName, double defaultValue, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        DynamicDoubleProperty dynamicProperty = this.dynamicPropertyFactory.getDoubleProperty(propName, defaultValue, propertyChangeCallback);
        DynamicDouble dynamicDouble = new DynamicDouble(dynamicProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicDouble);
        return dynamicDouble;
    }

    public float getFloat(String propName, float defaultValue) {
        this.validatePropertyName(propName);
        return this.dynamicPropertyFactory.getFloatProperty(propName, defaultValue, null).get();
    }

    public DynamicFloat getDynamicFloat(String propName, float defaultValue) {
        return this.getDynamicFloat(propName, defaultValue, null);
    }

    public DynamicFloat getDynamicFloat(String propName, float defaultValue, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        DynamicFloatProperty dynamicProperty = this.dynamicPropertyFactory.getFloatProperty(propName, defaultValue, propertyChangeCallback);
        DynamicFloat dynamicFloat = new DynamicFloat(dynamicProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicFloat);
        return dynamicFloat;
    }

    public int getInt(String propName, int defaultValue) {
        this.validatePropertyName(propName);
        return this.dynamicPropertyFactory.getIntProperty(propName, defaultValue, null).get();
    }

    public DynamicInt getDynamicInt(String propName, int defaultValue) {
        return this.getDynamicInt(propName, defaultValue, null);
    }

    public DynamicInt getDynamicInt(String propName, int defaultValue, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        DynamicIntProperty dynamicProperty = this.dynamicPropertyFactory.getIntProperty(propName, defaultValue, propertyChangeCallback);
        DynamicInt dynamicInt = new DynamicInt(dynamicProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicInt);
        return dynamicInt;
    }

    public long getLong(String propName, long defaultValue) {
        this.validatePropertyName(propName);
        return this.dynamicPropertyFactory.getLongProperty(propName, defaultValue, null).get();
    }

    public DynamicLong getDynamicLong(String propName, long defaultValue) {
        return this.getDynamicLong(propName, defaultValue, null);
    }

    public DynamicLong getDynamicLong(String propName, long defaultValue, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        DynamicLongProperty dynamicProperty = this.dynamicPropertyFactory.getLongProperty(propName, defaultValue, propertyChangeCallback);
        DynamicLong dynamicLong = new DynamicLong(dynamicProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicLong);
        return dynamicLong;
    }

    public TimeUnitConfiguration getTimeUnitConfiguration(String propName, TimeUnitConfiguration defaultValue) {
        this.validatePropertyName(propName);
        return new DynamicTimeUnitConfigurationProperty(propName, defaultValue).get();
    }

    public DynamicTimeUnitConfiguration getDynamicTimeUnitConfiguration(String propName, TimeUnitConfiguration defaultValue) {
        return this.getDynamicTimeUnitConfiguration(propName, defaultValue, null);
    }

    public DynamicTimeUnitConfiguration getDynamicTimeUnitConfiguration(String propName, TimeUnitConfiguration defaultValue, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        DynamicTimeUnitConfigurationProperty dynamicProperty = new DynamicTimeUnitConfigurationProperty(propName, defaultValue);
        dynamicProperty.addCallback(propertyChangeCallback);
        DynamicTimeUnitConfiguration dynamicTimeUnitConfiguration = new DynamicTimeUnitConfiguration(dynamicProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicTimeUnitConfiguration);
        return dynamicTimeUnitConfiguration;
    }

    public <E extends Enum<E>> E getEnum(String propName, E defaultValue) {
        this.validatePropertyName(propName);
        return new DynamicEnumProperty<E>(propName, defaultValue).get();
    }

    public <E extends Enum<E>> DynamicEnum<E> getDynamicEnum(String propName, E defaultValue) {
        return this.getDynamicEnum(propName, defaultValue, null);
    }

    public <E extends Enum<E>> DynamicEnum<E> getDynamicEnum(String propName, E defaultValue, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        DynamicEnumProperty<E> dynamicProperty = new DynamicEnumProperty<E>(propName, defaultValue);
        dynamicProperty.addCallback(propertyChangeCallback);
        DynamicEnum<E> dynamicEnum = new DynamicEnum<E>(dynamicProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicEnum);
        return dynamicEnum;
    }

    public Set<String> getStringSet(String propName, @Nullable Set<String> defaultValue) {
        this.validatePropertyName(propName);
        return new DynamicStringSetProperty(propName, defaultValue).get();
    }

    public Set<String> getStringSet(String propName, @Nullable Set<String> defaultValue, String listDelimiterRegex) {
        this.validatePropertyName(propName);
        return new DynamicStringSetProperty(propName, defaultValue, listDelimiterRegex).get();
    }

    public DynamicSet<String> getDynamicStringSet(String propName, @Nullable Set<String> defaultValue) {
        return this.getDynamicStringSet(propName, defaultValue, DEFAULT_LIST_DELIMITER, null);
    }

    public DynamicSet<String> getDynamicStringSet(String propName, @Nullable Set<String> defaultValue, String listDelimiterRegex) {
        return this.getDynamicStringSet(propName, defaultValue, listDelimiterRegex, null);
    }

    public DynamicSet<String> getDynamicStringSet(String propName, @Nullable Set<String> defaultValue, String listDelimiterRegex, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)listDelimiterRegex), (Object)"listDelimiterRegex can't be blank");
        DynamicStringSetProperty dynamicSetProperty = new DynamicStringSetProperty(propName, defaultValue, listDelimiterRegex);
        dynamicSetProperty.addCallback(propertyChangeCallback);
        DynamicSetString dynamicSet = new DynamicSetString((DynamicSetProperty<String>)dynamicSetProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicSet);
        return dynamicSet;
    }

    public List<String> getStringList(String propName, @Nullable List<String> defaultValue) {
        this.validatePropertyName(propName);
        return new DynamicStringListProperty(propName, defaultValue).get();
    }

    public List<String> getStringList(String propName, @Nullable List<String> defaultValue, String listDelimiterRegex) {
        this.validatePropertyName(propName);
        return new DynamicStringListProperty(propName, defaultValue, listDelimiterRegex).get();
    }

    public DynamicList<String> getDynamicStringList(String propName, @Nullable List<String> defaultValue) {
        return this.getDynamicStringList(propName, defaultValue, DEFAULT_LIST_DELIMITER, null);
    }

    public DynamicList<String> getDynamicStringList(String propName, @Nullable List<String> defaultValue, String listDelimiterRegex) {
        return this.getDynamicStringList(propName, defaultValue, listDelimiterRegex, null);
    }

    public DynamicList<String> getDynamicStringList(String propName, @Nullable List<String> defaultValue, String listDelimiterRegex, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)listDelimiterRegex), (Object)"listDelimiterRegex can't be blank");
        DynamicStringListProperty dynamicListProperty = new DynamicStringListProperty(propName, defaultValue, listDelimiterRegex);
        dynamicListProperty.addCallback(propertyChangeCallback);
        DynamicListString dynamicList = new DynamicListString((DynamicListProperty<String>)dynamicListProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicList);
        return dynamicList;
    }

    public DynamicList<Integer> getDynamicIntegerList(String propName, @Nullable List<Integer> defaultValue, String listDelimiterRegex, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)listDelimiterRegex), (Object)"listDelimiterRegex can't be blank");
        DynamicIntegerListProperty dynamicListProperty = new DynamicIntegerListProperty(propName, defaultValue, listDelimiterRegex);
        dynamicListProperty.addCallback(propertyChangeCallback);
        DynamicList<Integer> dynamicList = new DynamicList<Integer>(dynamicListProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicList);
        return dynamicList;
    }

    public DynamicList<Long> getDynamicLongList(String propName, @Nullable List<Long> defaultValue, String listDelimiterRegex, @Nullable Runnable propertyChangeCallback) {
        this.validatePropertyName(propName);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)listDelimiterRegex), (Object)"listDelimiterRegex can't be blank");
        DynamicLongListProperty dynamicListProperty = new DynamicLongListProperty(propName, defaultValue, listDelimiterRegex);
        dynamicListProperty.addCallback(propertyChangeCallback);
        DynamicList<Long> dynamicList = new DynamicList<Long>(dynamicListProperty);
        this.allDynamicProperties.putIfAbsent(propName, dynamicList);
        return dynamicList;
    }

    public Map<String, DynamicProperty<?>> getAllDynamicProperties() {
        return ImmutableMap.copyOf(this.allDynamicProperties);
    }

    @Override
    public void close() throws IOException {
        Object configuration = DynamicPropertyFactory.getBackingConfigurationSource();
        if (configuration instanceof Closeable) {
            ((Closeable)configuration).close();
        }
    }

    public void stop() {
        try {
            this.close();
        }
        catch (IOException e) {
            log.warn("An error occurred attempting to close ConfigurationProperties", (Throwable)e);
        }
    }

    public String toString() {
        return String.format("ConfigurationProperties: [Backing Configuration Source: [%s]]", DynamicPropertyFactory.getBackingConfigurationSource());
    }

    private void validatePropertyName(String propName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)propName), (Object)"property name can't be blank");
    }
}

