/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.io.tcp;

import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.configuration.CommonReader;
import com.appdynamics.common.util.exception.Exceptions;
import com.appdynamics.common.util.item.Item;
import com.google.common.net.HostAndPort;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpClient
implements Item<String>,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TcpClient.class);
    private final String id;
    private final EventLoopGroup workerGroup;
    private final ChannelFuture channelFuture;

    public TcpClient(Parameters parameters) {
        this.id = parameters.getId();
        log.info("Starting [{}]", (Object)parameters);
        NioEventLoopGroup workerGroup = null;
        ChannelFuture channelFuture = null;
        try {
            workerGroup = new NioEventLoopGroup(parameters.getNumWorkerThreads(), ConcurrencyHelper.newDaemonThreadFactory((String)(parameters.getId() + "-worker-%d")));
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)workerGroup)).channel(NioSocketChannel.class);
            for (Map.Entry<ChannelOption<Object>, Object> entry : parameters.getChannelOptions().entrySet()) {
                bootstrap.option(entry.getKey(), entry.getValue());
            }
            bootstrap.handler(parameters.getHandler());
            String host = parameters.getHostAndPort().getHost();
            int port = parameters.getHostAndPort().getPort();
            channelFuture = bootstrap.connect(host, port);
            try {
                channelFuture.sync();
            }
            catch (InterruptedException e) {
                throw Exceptions.rethrowAsRuntimeException((InterruptedException)e);
            }
        }
        catch (Throwable t) {
            if (workerGroup != null) {
                workerGroup.shutdownGracefully();
            }
            throw t;
        }
        this.workerGroup = workerGroup;
        this.channelFuture = channelFuture;
        log.info("Stopped [{}]", (Object)parameters);
    }

    public String getId() {
        return this.id;
    }

    public Channel getChannel() {
        return this.channelFuture.channel();
    }

    @Override
    public void close() {
        log.info("Stopping [{}]", (Object)this.getId());
        try {
            this.channelFuture.channel().close().sync();
        }
        catch (InterruptedException e) {
            log.warn("Thread was interrupted while waiting for channel close", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.workerGroup.shutdownGracefully();
        log.info("Stopped [{}]", (Object)this.getId());
    }

    public static class Parameters {
        @NotNull
        private final String id;
        @NotNull
        private final HostAndPort hostAndPort;
        @Min(value=1L)
        private final @Min(value=1L) int numWorkerThreads;
        @NotNull
        private final Map<ChannelOption<Object>, Object> channelOptions;
        @NotNull
        private final ChannelInitializer<SocketChannel> handler;

        public Parameters validate() {
            CommonReader.validate((Object)this);
            return this;
        }

        @ConstructorProperties(value={"id", "hostAndPort", "numWorkerThreads", "channelOptions", "handler"})
        @Generated
        Parameters(String id, HostAndPort hostAndPort, int numWorkerThreads, Map<ChannelOption<Object>, Object> channelOptions, ChannelInitializer<SocketChannel> handler) {
            this.id = id;
            this.hostAndPort = hostAndPort;
            this.numWorkerThreads = numWorkerThreads;
            this.channelOptions = channelOptions;
            this.handler = handler;
        }

        @Generated
        public static ParametersBuilder builder() {
            return new ParametersBuilder();
        }

        @Generated
        public String toString() {
            return "TcpClient.Parameters(id=" + this.getId() + ", hostAndPort=" + String.valueOf(this.getHostAndPort()) + ", numWorkerThreads=" + this.getNumWorkerThreads() + ", channelOptions=" + String.valueOf(this.getChannelOptions()) + ", handler=" + String.valueOf(this.getHandler()) + ")";
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public HostAndPort getHostAndPort() {
            return this.hostAndPort;
        }

        @Generated
        public int getNumWorkerThreads() {
            return this.numWorkerThreads;
        }

        @Generated
        public Map<ChannelOption<Object>, Object> getChannelOptions() {
            return this.channelOptions;
        }

        @Generated
        public ChannelInitializer<SocketChannel> getHandler() {
            return this.handler;
        }

        @Generated
        public static class ParametersBuilder {
            @Generated
            private String id;
            @Generated
            private HostAndPort hostAndPort;
            @Generated
            private int numWorkerThreads;
            @Generated
            private Map<ChannelOption<Object>, Object> channelOptions;
            @Generated
            private ChannelInitializer<SocketChannel> handler;

            @Generated
            ParametersBuilder() {
            }

            @Generated
            public ParametersBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public ParametersBuilder hostAndPort(HostAndPort hostAndPort) {
                this.hostAndPort = hostAndPort;
                return this;
            }

            @Generated
            public ParametersBuilder numWorkerThreads(int numWorkerThreads) {
                this.numWorkerThreads = numWorkerThreads;
                return this;
            }

            @Generated
            public ParametersBuilder channelOptions(Map<ChannelOption<Object>, Object> channelOptions) {
                this.channelOptions = channelOptions;
                return this;
            }

            @Generated
            public ParametersBuilder handler(ChannelInitializer<SocketChannel> handler) {
                this.handler = handler;
                return this;
            }

            @Generated
            public Parameters build() {
                return new Parameters(this.id, this.hostAndPort, this.numWorkerThreads, this.channelOptions, this.handler);
            }

            @Generated
            public String toString() {
                return "TcpClient.Parameters.ParametersBuilder(id=" + this.id + ", hostAndPort=" + String.valueOf(this.hostAndPort) + ", numWorkerThreads=" + this.numWorkerThreads + ", channelOptions=" + String.valueOf(this.channelOptions) + ", handler=" + String.valueOf(this.handler) + ")";
            }
        }
    }
}

