/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.io.http;

import com.appdynamics.analytics.io.http.BtReceiverConfiguration;
import com.appdynamics.analytics.pipeline.http.AbstractPostReceiver;
import com.appdynamics.common.io.codec.Utf8String;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PreDestroy;

public class BtReceiver
extends AbstractPostReceiver<String, BtReceiverConfiguration> {
    public static final String HTTP_ACCESS_KEY_HEADER = "X-Analytics-Agent-Access-Key";
    private static final ThreadLocal<Utf8String.Decoder> TLS_UTF8_DECODERS = new ThreadLocal<Utf8String.Decoder>(){

        @Override
        protected Utf8String.Decoder initialValue() {
            return Utf8String.newDecoder();
        }
    };
    private static final String ERR_MSG_AUTH_FAILURE = "Credentials may be wrong";
    private boolean authenticate;
    private String accountName;
    private String accessKey;

    public void onStart() {
        super.onStart();
        this.configureOnStart((BtReceiverConfiguration)((Object)this.getConfiguration()));
    }

    @PreDestroy
    public void cleanup() {
        TLS_UTF8_DECODERS.remove();
    }

    @VisibleForTesting
    final void configureOnStart(BtReceiverConfiguration cfg) {
        this.authenticate = cfg.isAuthenticate();
        this.accountName = cfg.getAccountName();
        this.accessKey = cfg.getAccessKey();
    }

    protected String process(HttpServletRequest request, HttpServletResponse response) throws IOException, AbstractPostReceiver.ManagedException {
        try (ServletInputStream inputStream = request.getInputStream();){
            if (this.authenticate) {
                this.authenticate(request);
            }
            Utf8String.Decoder decoder = TLS_UTF8_DECODERS.get();
            String string = decoder.decode((InputStream)inputStream);
            return string;
        }
    }

    private void authenticate(HttpServletRequest request) throws AbstractPostReceiver.ManagedException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.length() <= 1) {
            throw new AbstractPostReceiver.ManagedException(401, ERR_MSG_AUTH_FAILURE);
        }
        String receivedAccountName = pathInfo.substring(1);
        String receivedAccessKey = request.getHeader(HTTP_ACCESS_KEY_HEADER);
        if (!this.accountName.equals(receivedAccountName) || !this.accessKey.equals(receivedAccessKey)) {
            throw new AbstractPostReceiver.ManagedException(401, ERR_MSG_AUTH_FAILURE);
        }
    }
}

