/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync.registration;

import com.appdynamics.analytics.agent.sync.AgentConfigurationState;
import com.appdynamics.analytics.agent.sync.AgentHealthManager;
import com.appdynamics.analytics.agent.sync.AgentTagManager;
import com.appdynamics.analytics.agent.sync.AnalyticsAgentSyncConfiguration;
import com.appdynamics.analytics.agent.sync.ChannelManager;
import com.appdynamics.analytics.agent.sync.ErrorMessageHelper;
import com.appdynamics.analytics.agent.sync.registration.AgentRegistrationClient;
import com.appdynamics.analytics.agent.sync.registration.DefaultAgentRegistrationClient;
import com.appdynamics.analytics.client.common.exceptions.ClientException;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.log.shared.dto.AgentRegistrationRequest;
import com.appdynamics.analytics.log.shared.dto.AgentRegistrationResponse;
import com.appdynamics.common.framework.AppInfo;
import com.appdynamics.common.framework.version.CalendarVersion;
import com.appdynamics.common.io.IoHelper;
import com.appdynamics.common.util.configuration.Sanitizer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.net.InetAddresses;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationChannelManager
extends ChannelManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistrationChannelManager.class);
    private final String agentName;
    private final String uniqueHostName;
    private final AppInfo appInfo;
    private AnalyticsAgentSyncConfiguration configuration;
    private AgentRegistrationClient registrationClient;

    public RegistrationChannelManager(AnalyticsAgentSyncConfiguration configuration, AgentTagManager agentTagManager, AgentHealthManager agentHealthManager, AgentConfigurationState agentConfigurationState, AppInfo appInfo) {
        super(agentConfigurationState, agentTagManager, agentHealthManager, configuration.getCustomerName(), configuration.getAccessKey());
        this.appInfo = appInfo;
        this.agentName = configuration.getAgentName();
        this.uniqueHostName = this.getUniqueHostName(configuration);
        this.configuration = configuration;
        this.registrationClient = null;
    }

    protected AgentRegistrationClient getRegistrationClient() {
        if (this.registrationClient == null) {
            URI syncUri = URI.create(this.configuration.getControllerUrl());
            log.info("Trust store being used for communication with the Controller [{}]", (Object)this.configuration.getTrustStorePath());
            this.registrationClient = (AgentRegistrationClient)DefaultAgentRegistrationClient.builder(syncUri.getScheme(), syncUri.getHost(), syncUri.getPort()).proxyConfig(this.configuration.getProxyHost(), this.configuration.getProxyPort(), this.configuration.getProxyUsername(), this.configuration.getProxyPassword()).trustStoreConfig(this.configuration.getTrustStorePath(), this.configuration.getTrustStorePassword(), this.configuration.getTrustStoreType()).socketTimeoutMillis((int)this.configuration.getSocketTimeoutInterval().toMilliseconds()).connectionTimeoutMillis((int)this.configuration.getConnectionTimeoutInterval().toMilliseconds()).maxConnectionsPerRoute(1).maxTotalConnections(1).mapper(new ObjectMapper()).setTlsVersion(this.configuration.getControllerTlsVersion()).build();
        }
        return this.registrationClient;
    }

    @Override
    public boolean sync() {
        try {
            AgentRegistrationRequest request = this.makeAgentRegistrationRequest();
            AgentRegistrationResponse response = this.getRegistrationClient().register(this.getAuthAccount(), this.getAccessKey(), request);
            if (response == null) {
                return false;
            }
            log.info("Analytics [{}]/[{}] agent registered and assigned agent id [{}]", new Object[]{request.getName(), request.getHostName(), response.getAgentId()});
            AgentConfigurationState agentConfigurationState = this.getAgentConfigurationState();
            agentConfigurationState.setAgentId(response.getAgentId());
            agentConfigurationState.setEnabled(response.isEnabled());
        }
        catch (RestException e) {
            ErrorMessageHelper.logFriendlyErrorMessage("registration", e);
            return false;
        }
        catch (ClientException e) {
            ErrorMessageHelper.logFriendlyErrorMessage("registration", e);
            return false;
        }
        catch (Exception e) {
            log.error("Analytics agent failed to register with controller.", (Throwable)e);
            return false;
        }
        return true;
    }

    private AgentRegistrationRequest makeAgentRegistrationRequest() {
        AgentRegistrationRequest registrationRequest = new AgentRegistrationRequest();
        registrationRequest.setAgentRuntime(this.getJreVersion());
        registrationRequest.setHostName(this.uniqueHostName);
        registrationRequest.setName(this.agentName);
        CalendarVersion calendarVersion = this.appInfo.getVersion();
        registrationRequest.setMajorVersion(calendarVersion.getYear());
        registrationRequest.setMinorVersion(calendarVersion.getMonth());
        registrationRequest.setPointRelease(calendarVersion.getIteration());
        registrationRequest.setAgentPointRelease(calendarVersion.getBuildNumber());
        registrationRequest.setInstallDir(this.resolveInstallDir());
        registrationRequest.setAgentTags(this.getAgentTagManager().getCurrentAgentTags().getTags());
        registrationRequest.setAgentHealth(this.getAgentHealthManager().extractAgentHealth());
        return registrationRequest;
    }

    private String getUniqueHostName(AnalyticsAgentSyncConfiguration configuration) {
        String hostName;
        if (StringUtils.isNotBlank((CharSequence)configuration.getUniqueHostName())) {
            hostName = configuration.getUniqueHostName();
        } else {
            try {
                hostName = RegistrationChannelManager.getLocalHostName();
                if (configuration.isUseSimpleHostName()) {
                    hostName = RegistrationChannelManager.simplifyHostname(hostName);
                }
            }
            catch (Throwable e) {
                hostName = "unknown";
            }
        }
        return hostName;
    }

    @VisibleForTesting
    static String simplifyHostname(String hostName) {
        if (InetAddresses.isInetAddress((String)hostName)) {
            return hostName;
        }
        if (hostName.contains(".")) {
            String[] split = hostName.split("\\.");
            hostName = split[0];
        }
        return hostName;
    }

    @VisibleForTesting
    String resolveInstallDir() {
        String installDir = this.configuration.getInstallDir();
        if (installDir == null) {
            installDir = this.getInstallDirFromClassLocation();
        }
        Preconditions.checkState((installDir != null ? 1 : 0) != 0, (Object)"The install directory could not be found");
        return installDir;
    }

    private String getInstallDirFromClassLocation() {
        Path installDirPath;
        String libDir;
        String path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            libDir = URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Path libDirPath = IoHelper.createOsSpecificPath((String)libDir);
        if (libDirPath != null && (installDirPath = libDirPath.getParent()) != null) {
            return installDirPath.toString();
        }
        return null;
    }

    private String getJreVersion() {
        String version = Sanitizer.sanitizeForDisplay((String)System.getProperty("java.version"));
        if (version == null) {
            version = "unknown";
        }
        return version;
    }

    private static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }
}

