/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync.configuration;

import com.appdynamics.analytics.agent.sync.configuration.AgentSourceConfigurationClient;
import com.appdynamics.analytics.client.common.AbstractAnalyticsClient;
import com.appdynamics.analytics.client.common.HttpEntityEnclosingRequestBuilder;
import com.appdynamics.analytics.log.shared.dto.AgentConfigurationRequest;
import com.appdynamics.analytics.log.shared.dto.AgentSourceConfiguration;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.net.URI;
import lombok.Generated;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAgentConfigurationClient
extends AbstractAnalyticsClient
implements AgentSourceConfigurationClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAgentConfigurationClient.class);
    public static final String CONFIGURATION_PATH = "/rest/analytics/agent/%d/config";

    public DefaultAgentConfigurationClient(ObjectMapper mapper, CloseableHttpClient client, URI baseUri) {
        super(mapper, client, baseUri);
    }

    public static AbstractAnalyticsClient.Builder<DefaultAgentConfigurationClient> builder(String schema, String hostName, int port) {
        return AbstractAnalyticsClient.builder(DefaultAgentConfigurationClient.class, (String)schema, (String)hostName, (int)port).basePath("/").cookieSpec("standard");
    }

    @Override
    public AgentSourceConfiguration getSourceConfigurations(String accountName, String accessKey, Long agentId, AgentConfigurationRequest configurationRequest, Long prevConfigHash) {
        try {
            String prevConfigHashString = "";
            if (prevConfigHash != null) {
                prevConfigHashString = prevConfigHash.toString();
            }
            String response = ((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)this.getRequestFactory().post().appendPath(String.format(CONFIGURATION_PATH, agentId), new String[0])).addHeader("Authorization", DefaultAgentConfigurationClient.buildStandardAuthHeader((String)accountName, (String)accessKey))).addQueryParam("prevConfigHash", prevConfigHashString)).setRequestEntity((Object)configurationRequest).expecting(200)).executeAndReturnRawResponseString();
            return (AgentSourceConfiguration)this.getMapper().readValue(response, AgentSourceConfiguration.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

