/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync.configuration;

import com.appdynamics.analytics.agent.configurator.LogSourceConfigurationConverter;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.LogSources;
import com.appdynamics.analytics.agent.sync.AgentConfigurationState;
import com.appdynamics.analytics.agent.sync.AgentHealth;
import com.appdynamics.analytics.agent.sync.AgentHealthManager;
import com.appdynamics.analytics.agent.sync.AgentTagManager;
import com.appdynamics.analytics.agent.sync.AgentTags;
import com.appdynamics.analytics.agent.sync.AnalyticsAgentSyncConfiguration;
import com.appdynamics.analytics.agent.sync.ChannelManager;
import com.appdynamics.analytics.agent.sync.ErrorMessageHelper;
import com.appdynamics.analytics.agent.sync.configuration.AgentSourceConfigurationClient;
import com.appdynamics.analytics.agent.sync.configuration.ConfigurationSyncEvent;
import com.appdynamics.analytics.agent.sync.configuration.DefaultAgentConfigurationClient;
import com.appdynamics.analytics.client.common.exceptions.ClientException;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.log.shared.agent.ConfigurationConstants;
import com.appdynamics.analytics.log.shared.dto.AgentConfigurationRequest;
import com.appdynamics.analytics.log.shared.dto.AgentSourceConfiguration;
import com.appdynamics.analytics.log.shared.dto.LogSourceConfigurationDTO;
import com.appdynamics.common.util.event.EventBuses;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationChannelManager
extends ChannelManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationChannelManager.class);
    private final AnalyticsAgentSyncConfiguration configuration;
    private AgentSourceConfigurationClient configurationClient;
    private final LogSources logSources;
    private final EventBuses eventBuses;
    private long prevConfigHash;

    public ConfigurationChannelManager(AnalyticsAgentSyncConfiguration configuration, AgentTagManager agentTagManager, AgentHealthManager agentHealthManager, AgentConfigurationState agentConfigurationState, LogSources logSources, EventBuses eventBuses) {
        super(agentConfigurationState, agentTagManager, agentHealthManager, configuration.getCustomerName(), configuration.getAccessKey());
        this.logSources = logSources;
        this.configuration = configuration;
        this.configurationClient = null;
        this.eventBuses = eventBuses;
        this.prevConfigHash = ConfigurationConstants.CONFIG_NO_CHANGE_SENTINEL;
    }

    @VisibleForTesting
    protected AgentSourceConfigurationClient getConfigurationClient() {
        if (this.configurationClient == null) {
            URI syncUri = URI.create(this.configuration.getControllerUrl());
            this.configurationClient = (AgentSourceConfigurationClient)DefaultAgentConfigurationClient.builder(syncUri.getScheme(), syncUri.getHost(), syncUri.getPort()).proxyConfig(this.configuration.getProxyHost(), this.configuration.getProxyPort(), this.configuration.getProxyUsername(), this.configuration.getProxyPassword()).trustStoreConfig(this.configuration.getTrustStorePath(), this.configuration.getTrustStorePassword(), this.configuration.getTrustStoreType()).socketTimeoutMillis((int)this.configuration.getSocketTimeoutInterval().toMilliseconds()).connectionTimeoutMillis((int)this.configuration.getConnectionTimeoutInterval().toMilliseconds()).maxConnectionsPerRoute(1).maxTotalConnections(1).mapper(new ObjectMapper()).setTlsVersion(this.configuration.getControllerTlsVersion()).build();
        }
        return this.configurationClient;
    }

    @Override
    public boolean sync() {
        try {
            AgentConfigurationRequest configurationRequest = new AgentConfigurationRequest();
            AgentTags agentTags = this.getAgentTagManager().getCurrentAgentTags();
            configurationRequest.setAgentTags(agentTags.getTags());
            AgentHealth agentHealth = this.getAgentHealthManager().extractAgentHealth();
            configurationRequest.setAgentHealth(agentHealth);
            AgentSourceConfiguration config = this.getConfigurationClient().getSourceConfigurations(this.getAuthAccount(), this.getAccessKey(), this.getAgentConfigurationState().getAgentId(), configurationRequest, this.prevConfigHash);
            this.getAgentHealthManager().setHealthErrorThreshold(config.getHealthErrorThreshold());
            this.logSources.updateDisableSources(config.isDisableAllLocalSources(), config.isDisableAllSources(), config.getPermanentDisabledConfigs());
            if (config.getLscConfigHash() == ConfigurationConstants.CONFIG_NO_CHANGE_SENTINEL.longValue()) {
                log.debug("Synced the following agent configuration: [{}], unchanged from last sync, skipping.", (Object)config);
            } else {
                log.info("Received the following configuration from the controller. [{}]", (Object)config);
                if (config.getLogSourceConfigurationDTOs() == null) {
                    ArrayList emptyList = new ArrayList();
                    config.setLogSourceConfigurationDTOs(emptyList);
                }
                this.applyChangedSourceConfigurations(config);
                this.prevConfigHash = config.getLscConfigHash();
            }
            this.eventBuses.postEvent("default-event-bus", (Object)new ConfigurationSyncEvent(config));
        }
        catch (RestException e) {
            ErrorMessageHelper.logFriendlyErrorMessage("configuration", e);
            return false;
        }
        catch (ClientException e) {
            ErrorMessageHelper.logFriendlyErrorMessage("configuration", e);
            return false;
        }
        catch (Exception e) {
            log.error("Analytics agent failed to sync log source configuration.", (Throwable)e);
            return false;
        }
        return true;
    }

    private void applyChangedSourceConfigurations(AgentSourceConfiguration configUpdate) {
        Map<String, LogSourceConfigurationDTO> currentSources = this.getAgentConfigurationState().getConfigurationMap();
        ArrayList<LogSourceConfigurationDTO> upsertSources = new ArrayList<LogSourceConfigurationDTO>();
        ArrayList<String> deleteSourceIds = new ArrayList<String>();
        deleteSourceIds.addAll(currentSources.keySet());
        for (LogSourceConfigurationDTO newSource : configUpdate.getLogSourceConfigurationDTOs()) {
            String sourceId = newSource.getLogSourceId();
            LogSourceConfigurationDTO matchingSource = currentSources.get(sourceId);
            if (matchingSource != null) {
                if (matchingSource.getRevisionNumber() < newSource.getRevisionNumber()) {
                    upsertSources.add(newSource);
                }
            } else {
                upsertSources.add(newSource);
            }
            deleteSourceIds.remove(sourceId);
        }
        this.getAgentConfigurationState().setConfigurationMap(configUpdate.toLogSourceConfigurationMap());
        this.logSources.updateRemoteSources(this.convertSourceConfigurations(upsertSources), deleteSourceIds);
    }

    private Collection<LogSourceConfiguration> convertSourceConfigurations(Collection<LogSourceConfigurationDTO> logSourceConfigurationDTOs) {
        ArrayList<LogSourceConfiguration> logSourceConfigurations = new ArrayList<LogSourceConfiguration>(logSourceConfigurationDTOs.size());
        for (LogSourceConfigurationDTO logSourceConfigurationDTO : logSourceConfigurationDTOs) {
            LogSourceConfiguration logSourceConfiguration = LogSourceConfigurationConverter.getLogSourceConfigurationFromDTO(logSourceConfigurationDTO);
            logSourceConfiguration.setRevisionNumber(logSourceConfigurationDTO.getRevisionNumber());
            logSourceConfiguration.setRemoteConfigured(true);
            logSourceConfigurations.add(logSourceConfiguration);
        }
        return logSourceConfigurations;
    }
}

