/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync;

import com.appdynamics.analytics.client.common.exceptions.ClientException;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import java.net.ConnectException;
import lombok.Generated;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageHelper.class);

    public static void logFriendlyErrorMessage(String contextMessage, RestException e) {
        if (e.getStatusCode() == 401) {
            log.error("Analytics agent failed to authenticate controller {} endpoint. Please verify the customer name, global account name, and access key are configured in the analytics-agent.properties", (Object)contextMessage);
        } else if (e.getStatusCode() == 404) {
            log.warn("Analytics agent failed to find the controller {} endpoint. This can happen if the  controller version is earlier than 4.3.", (Object)contextMessage);
        } else if (e.getStatusCode() == 500) {
            log.error("Analytics agent failed to communicate with the controller {} endpoint due to a server error. The controller may be temporarily experiencing problems, if this persists please check the controller logs.", (Object)contextMessage);
        } else {
            log.error("Analytics agent failed to communicate with the controller {} endpoint.", (Object)contextMessage, (Object)e);
        }
    }

    public static void logFriendlyErrorMessage(String contextMessage, ClientException e) {
        if (e.getCause() instanceof ConnectException) {
            log.error("Analytics agent failed to connect to the controller {} endpoint. This can happen when the connection is refused remotely, or when there is no process listening on the remote address/port. Please check to see if the controller address is configured correctly and is running.", (Object)contextMessage);
        } else if (e.getCause() instanceof HttpHostConnectException) {
            HttpHostConnectException e2 = (HttpHostConnectException)e.getCause();
            log.error("Analytics agent failed to connect to the controller {} endpoint. There was an error while attempting to connect a socket to the controller address and port at {}. Please check to see if the controller address is configured correctly and is running.", (Object)contextMessage, (Object)e2.getHost());
        } else {
            log.error("Analytics agent failed to connect to the controller {} endpoint.", (Object)contextMessage, (Object)e);
        }
    }
}

