/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync;

import com.appdynamics.analytics.agent.sync.AgentConfigurationState;
import com.appdynamics.analytics.agent.sync.AgentHealthManager;
import com.appdynamics.analytics.agent.sync.AgentTagManager;
import lombok.Generated;

public abstract class ChannelManager {
    private static final String SINGULARITY_AGENT = "singularity-agent";
    private final AgentConfigurationState agentConfigurationState;
    private final AgentTagManager agentTagManager;
    private final AgentHealthManager agentHealthManager;
    private final String authAccount;
    private final String accessKey;

    protected ChannelManager(AgentConfigurationState agentConfigurationState, AgentTagManager agentTagManager, AgentHealthManager agentHealthManager, String customerName, String accessKey) {
        this.agentConfigurationState = agentConfigurationState;
        this.agentTagManager = agentTagManager;
        this.agentHealthManager = agentHealthManager;
        this.authAccount = ChannelManager.buildAuthAccountName(customerName);
        this.accessKey = accessKey;
    }

    public abstract boolean sync();

    public static String buildAuthAccountName(String customerName) {
        return String.format("%s@%s", SINGULARITY_AGENT, customerName);
    }

    @Generated
    protected AgentConfigurationState getAgentConfigurationState() {
        return this.agentConfigurationState;
    }

    @Generated
    protected AgentTagManager getAgentTagManager() {
        return this.agentTagManager;
    }

    @Generated
    protected AgentHealthManager getAgentHealthManager() {
        return this.agentHealthManager;
    }

    @Generated
    protected String getAuthAccount() {
        return this.authAccount;
    }

    @Generated
    protected String getAccessKey() {
        return this.accessKey;
    }
}

