/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync;

import com.appdynamics.analytics.agent.source.LogSources;
import com.appdynamics.analytics.agent.sync.AgentConfigurationState;
import com.appdynamics.analytics.agent.sync.AgentHealthManager;
import com.appdynamics.analytics.agent.sync.AgentSyncLifecycleManager;
import com.appdynamics.analytics.agent.sync.AgentSyncLifecycleWrapper;
import com.appdynamics.analytics.agent.sync.AgentTagManager;
import com.appdynamics.analytics.agent.sync.AnalyticsAgentSyncConfiguration;
import com.appdynamics.analytics.agent.sync.configuration.ConfigurationChannelManager;
import com.appdynamics.analytics.agent.sync.registration.RegistrationChannelManager;
import com.appdynamics.common.framework.AppInfo;
import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.util.event.EventBuses;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.lifecycle.LifecycleInjector;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsAgentSyncModule
extends Module<AnalyticsAgentSyncConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyticsAgentSyncModule.class);

    @Provides
    @Singleton
    AgentConfigurationState makeAnalyticsSyncState() {
        return new AgentConfigurationState();
    }

    @Provides
    @Singleton
    AgentTagManager getAgentTagManager() {
        return new AgentTagManager(this.parseTags(((AnalyticsAgentSyncConfiguration)this.getConfiguration()).getAgentTags()));
    }

    @Provides
    @Singleton
    AgentHealthManager makeAgentHealthManager(ConsolidatedHealthCheck healthCheck) {
        AnalyticsAgentSyncConfiguration configuration = (AnalyticsAgentSyncConfiguration)this.getConfiguration();
        return new AgentHealthManager(configuration.getBizTxnsHealthCheckName(), configuration.getLogsHealthCheckName(), configuration.getEventServiceConnectionCheckName(), healthCheck);
    }

    @Provides
    @Singleton
    RegistrationChannelManager makeRegistrationSyncManager(AgentConfigurationState syncStateManager, AgentTagManager agentTagManager, AgentHealthManager agentHealthManager, AppInfo appInfo) {
        return new RegistrationChannelManager((AnalyticsAgentSyncConfiguration)this.getConfiguration(), agentTagManager, agentHealthManager, syncStateManager, appInfo);
    }

    @Provides
    @Singleton
    ConfigurationChannelManager makeConfigurationSyncManager(AgentConfigurationState syncStateManager, AgentTagManager agentTagManager, AgentHealthManager agentHealthManager, LogSources logSources, EventBuses eventBuses) {
        return new ConfigurationChannelManager((AnalyticsAgentSyncConfiguration)this.getConfiguration(), agentTagManager, agentHealthManager, syncStateManager, logSources, eventBuses);
    }

    @Provides
    @Singleton
    AgentSyncLifecycleWrapper makeAnalyticsAgentSync(RegistrationChannelManager registrationSyncManager, ConfigurationChannelManager configurationSyncManager, EventBuses eventBuses, LifecycleInjector lifecycleInjector, ConsolidatedHealthCheck healthCheck) {
        Optional optionalManager;
        String controllerUrl = ((AnalyticsAgentSyncConfiguration)this.getConfiguration()).getControllerUrl();
        if ("http://appd-analytics-clm-disabled.local".equalsIgnoreCase(controllerUrl)) {
            log.info("[{}] module has been disabled", (Object)AgentSyncLifecycleManager.class.getSimpleName());
            optionalManager = Optional.absent();
        } else {
            AgentSyncLifecycleManager syncLifecycleManager = new AgentSyncLifecycleManager((AnalyticsAgentSyncConfiguration)this.getConfiguration(), registrationSyncManager, configurationSyncManager, eventBuses, healthCheck);
            syncLifecycleManager = (AgentSyncLifecycleManager)lifecycleInjector.inject((Object)syncLifecycleManager);
            optionalManager = Optional.of((Object)syncLifecycleManager);
        }
        return new AgentSyncLifecycleWrapper((Optional<AgentSyncLifecycleManager>)optionalManager);
    }

    @Inject
    void selfStart(AgentSyncLifecycleWrapper agentSyncLifecycleWrapper) {
        if (agentSyncLifecycleWrapper.getManager().isPresent()) {
            log.info("Started");
        }
    }

    private Map<String, String> parseTags(String tagValueList) {
        if (StringUtils.isNotBlank((CharSequence)tagValueList)) {
            return new HashMap<String, String>(Splitter.on((char)',').withKeyValueSeparator('=').split((CharSequence)tagValueList));
        }
        return new HashMap<String, String>();
    }
}

