/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.sync;

import com.appdynamics.analytics.agent.sync.AnalyticsAgentSyncConfiguration;
import com.appdynamics.analytics.agent.sync.ChannelManager;
import com.appdynamics.analytics.agent.sync.ChannelState;
import com.appdynamics.analytics.agent.sync.ChannelStateManager;
import com.appdynamics.analytics.agent.sync.configuration.ConfigurationChannelManager;
import com.appdynamics.analytics.agent.sync.registration.RegistrationChannelManager;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.event.EventBuses;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.appdynamics.common.util.lifecycle.LifecycleAware;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentSyncLifecycleManager
implements LifecycleAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentSyncLifecycleManager.class);
    private static final int MAX_SHUTDOWN_WAIT_TIME_SECONDS = 1;
    private final ChannelStateManager stateManager;
    private final EnumMap<ChannelState, ChannelManager> syncManagers;
    private volatile boolean success;
    private ConsolidatedHealthCheck healthCheck;
    private ExecutorService executorService;

    protected AgentSyncLifecycleManager(AnalyticsAgentSyncConfiguration configuration, RegistrationChannelManager registrationManager, ConfigurationChannelManager configurationManager, EventBuses eventBuses, ConsolidatedHealthCheck healthCheck) {
        this.stateManager = new ChannelStateManager(configuration, ChannelState.REGISTRATION, eventBuses);
        this.syncManagers = new EnumMap(ImmutableMap.builder().put((Object)ChannelState.REGISTRATION, (Object)registrationManager).put((Object)ChannelState.CONFIGURATION, (Object)configurationManager).build());
        this.healthCheck = healthCheck;
        this.success = false;
    }

    public synchronized void start() {
        log.info("Starting analytics agent sync life cycle manager.");
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor(ConcurrencyHelper.newDaemonThreadFactory((String)"analytics-agent-sync-thread-%d"));
            this.executorService.submit(new SyncRunner());
            this.healthCheck.register((HealthCheckable)new ControllerConnectivityHealthCheck());
        } else {
            log.warn("Analytics agent sync life cycle manager attempted to be started multiple times!");
        }
    }

    public synchronized void stop() {
        log.info("Stopping analytics agent sync life cycle manager.");
        if (this.executorService != null) {
            boolean isTerminated = ConcurrencyHelper.stop((ExecutorService)this.executorService, (int)1, (Logger)log);
            if (isTerminated) {
                log.info("Successfully stopped the analytics agent sync life cycle manager.");
            } else {
                log.warn("Failed to stop analytics agent sync life cycle manager after waiting for [{}] second(s).", (Object)1);
            }
            this.executorService = null;
        } else {
            log.warn("Analytics agent sync life cycle manager was not started correctly.  Doing nothing on stop.");
        }
    }

    private class SyncRunner
    implements Runnable {
        private SyncRunner() {
        }

        @Override
        public void run() {
            try {
                log.info("Analytics agent syncing thread is starting up.");
                while (!Thread.currentThread().isInterrupted()) {
                    AgentSyncLifecycleManager.this.success = AgentSyncLifecycleManager.this.syncManagers.get((Object)AgentSyncLifecycleManager.this.stateManager.getCurrentState()).sync();
                    AgentSyncLifecycleManager.this.stateManager.transitionToNextState(AgentSyncLifecycleManager.this.success);
                    if (!AgentSyncLifecycleManager.this.success) {
                        log.warn("Failed to successfully sync [{}] ... retrying in [{}] seconds.", (Object)AgentSyncLifecycleManager.this.stateManager.getCurrentState(), (Object)(AgentSyncLifecycleManager.this.stateManager.getTimeToWaitUntilNextTransition() / 1000L));
                    }
                    try {
                        Thread.sleep(AgentSyncLifecycleManager.this.stateManager.getTimeToWaitUntilNextTransition());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                log.info("Analytics agent syncing thread is shutting down.");
            }
            catch (Exception e) {
                log.error("Unexpected error encountered... shutting down.", (Throwable)e);
            }
        }
    }

    private class ControllerConnectivityHealthCheck
    extends SimpleHealthCheck {
        public ControllerConnectivityHealthCheck() {
            super("Controller");
        }

        public HealthCheck.Result check() {
            if (AgentSyncLifecycleManager.this.success) {
                return HealthCheck.Result.healthy();
            }
            return HealthCheck.Result.unhealthy((String)"Failed to sync during [%s]", (Object[])new Object[]{AgentSyncLifecycleManager.this.stateManager.getCurrentState().name().toLowerCase()});
        }
    }
}

