/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source.tail;

import com.appdynamics.analytics.agent.input.tail.FileSignature;
import com.appdynamics.analytics.agent.input.tail.TailFileState;
import com.appdynamics.analytics.agent.input.tail.TailLogInput;
import com.appdynamics.analytics.agent.source.LogComponentFactory;
import com.appdynamics.analytics.agent.source.LogSource;
import com.appdynamics.analytics.agent.source.LogWatermarkState;
import com.appdynamics.analytics.agent.source.tail.DirectoryPoller;
import com.appdynamics.analytics.agent.source.tail.FileInputScanner;
import com.appdynamics.analytics.agent.source.tail.TailLogSourceConfiguration;
import com.appdynamics.analytics.agent.source.tail.TailLogWatermarkState;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.concurrent.ExitTrackableFutureTask;
import com.appdynamics.common.util.datetime.TimeKeeper;
import com.appdynamics.common.util.priority.PriorityExecutorServiceFactory;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailLogSource
extends LogSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TailLogSource.class);
    private static final int PASSIVE_THREAD_POOL_SIZE = 50;
    final ArrayList<TailLogInput> newInputs = new ArrayList();
    final ArrayList<TailLogInput> passiveNewInputs = new ArrayList();
    long nextDiscardTailingStateTime;
    boolean collectCompressed;
    final Map<TailFileState, TailLogInput> inputs = new ConcurrentHashMap<TailFileState, TailLogInput>();
    final Map<TailFileState, TailLogInput> passiveInputs;
    final Map<FileSignature, TailFileState> partialIdToTailStates = new ConcurrentHashMap<FileSignature, TailFileState>();
    final Map<FileSignature, TailFileState> fileIdToTailStates = new ConcurrentHashMap<FileSignature, TailFileState>();
    final PriorityBlockingQueue<Runnable> pendingInputQueue;
    final ThreadPoolExecutor inputThreadPool;
    final PriorityBlockingQueue<Runnable> passivePendingInputQueue;
    final ThreadPoolExecutor passiveThreadPool;
    private boolean isPassiveQueueActive;
    DirectoryPoller directoryPoller;
    ExitTrackableFutureTask inputScannerFutureTask;
    FileInputScanner inputScanner;

    public TailLogSource(TailLogSourceConfiguration configuration, LogComponentFactory factory, ExecutorService executorService) {
        super(String.format("TailLogSource [%s]", configuration.getId()), configuration, factory, executorService);
        this.collectCompressed = configuration.getCollectCompressed();
        int threadPoolSize = configuration.getMaximumInputPoolSize();
        if (threadPoolSize == 0) {
            threadPoolSize = 5;
        }
        this.pendingInputQueue = new PriorityBlockingQueue();
        this.inputThreadPool = PriorityExecutorServiceFactory.makeThreadPoolExecutor((int)threadPoolSize, (int)threadPoolSize, (long)60L, (TimeUnit)TimeUnit.SECONDS, this.pendingInputQueue, (ThreadFactory)ConcurrencyHelper.newDaemonThreadFactory((String)("tail-log-source-thread-" + String.valueOf(configuration.getId()) + "-%d")));
        this.inputThreadPool.allowCoreThreadTimeOut(true);
        this.passivePendingInputQueue = new PriorityBlockingQueue();
        this.passiveInputs = new ConcurrentHashMap<TailFileState, TailLogInput>();
        this.passiveThreadPool = PriorityExecutorServiceFactory.makeThreadPoolExecutor((int)50, (int)50, (long)60L, (TimeUnit)TimeUnit.SECONDS, this.passivePendingInputQueue, (ThreadFactory)ConcurrencyHelper.newDaemonThreadFactory((String)("tail-log-source-passive-thread-" + String.valueOf(configuration.getId()) + "-%d")));
        this.passiveThreadPool.allowCoreThreadTimeOut(true);
    }

    @Override
    public synchronized void start() {
        if (!this.isRunning()) {
            this.isPassiveQueueActive = true;
            super.start();
            this.updateNextDiscardTailingStateTime();
            this.startInputScanner();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.isRunning()) {
            super.stop();
            this.stopInputScanner();
            this.stopPassiveInputs(true);
            this.pendingInputQueue.clear();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (TailLogInput input : this.inputs.values()) {
                futures.add(CompletableFuture.runAsync(input.stopRunnable()));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).join();
            this.inputs.clear();
            ConcurrencyHelper.stop((ExecutorService)this.inputThreadPool, (Logger)log);
            this.directoryPoller = null;
            this.inputScanner = null;
        }
    }

    void startNewInputs(List<TailLogInput> newInputs) {
        for (TailLogInput input : newInputs) {
            try {
                input.start();
            }
            catch (Exception e) {
                log.error("Failed to start input [{}]", (Object)input.getName(), (Object)e);
                input.releaseResources();
            }
        }
        newInputs.clear();
    }

    void stopIdleInputs(Map<TailFileState, TailLogInput> inputs) {
        long currentTime = System.currentTimeMillis();
        for (TailLogInput input : inputs.values()) {
            boolean stopInput = false;
            TailFileState tailState = input.getTailState();
            long sinceLastActivityMillis = currentTime - input.getLastActivityTimestamp();
            if (input.isTailing()) {
                if (sinceLastActivityMillis >= this.getTailLogSourceConfiguration().getStopIdleInputsTimeout().toMilliseconds()) {
                    log.info("Input [{}] with signature [{}] has been idle for [{}] seconds, so it will be stopped", new Object[]{tailState.getFilename(), tailState.getSignature(), sinceLastActivityMillis / 1000L});
                    stopInput = true;
                }
            } else if (input.isFailed() && sinceLastActivityMillis >= this.getTailLogSourceConfiguration().getStopFailedInputsWaitTime().toMilliseconds()) {
                log.info("Input [{}] with signature [{}] failed with error, waited [{}] seconds before available to retry.", new Object[]{tailState.getFilename(), tailState.getSignature(), sinceLastActivityMillis / 1000L});
                stopInput = true;
            }
            if (!stopInput) continue;
            try {
                input.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop input [{}]", (Object)input.getName(), (Object)e);
            }
            inputs.remove(tailState);
            this.inputScanner.clearFileCacheWithFileSignature(tailState.getSignature().getSignature());
        }
    }

    void checkDiscardOldTailStates(Map<FileSignature, TailFileState> tailStatesMap) {
        long currentTime = System.currentTimeMillis();
        for (TailFileState tailFileState : tailStatesMap.values()) {
            long discardTimeout;
            long scannedTime = currentTime - tailFileState.getLastScanned();
            if (scannedTime < (discardTimeout = this.getTailLogSourceConfiguration().getDiscardTailingStateTimeout().toMilliseconds()) || this.inputs.containsKey(tailFileState)) continue;
            tailStatesMap.remove(tailFileState.getSignature());
        }
    }

    void checkDiscardOldTailStates() {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.nextDiscardTailingStateTime) {
            this.checkDiscardOldTailStates(this.partialIdToTailStates);
            this.checkDiscardOldTailStates(this.fileIdToTailStates);
            this.updateNextDiscardTailingStateTime();
        }
    }

    protected void initializeDirectoryPoller() {
        this.directoryPoller = this.factory.createDirectoryPoller(this.getTailLogSourceConfiguration().getSourcePath(), this.collectCompressed);
    }

    protected void initializeInputScanner() {
        this.inputScanner = this.factory.createFileInputScanner(this.directoryPoller, this.partialIdToTailStates, this.fileIdToTailStates, new Function<TailFileState, Boolean>(){

            public Boolean apply(TailFileState tailState) {
                if (!TailLogSource.this.inputs.containsKey(tailState) && !TailLogSource.this.passiveInputs.containsKey(tailState)) {
                    TailLogSource.this.addTailLogInput(tailState);
                    return true;
                }
                return false;
            }
        }, super.getConfiguration().getCollectLastNHours());
    }

    protected TailLogInput addTailLogInput(TailFileState tailState) {
        TailLogInput input = null;
        try {
            if (this.isPassiveQueueActive && this.inputScanner.getInitialScan() > tailState.getLastModifiedTimestamp()) {
                log.debug("Adding file [{}] to passive ThreadPool", (Object)tailState.getFilename());
                input = new TailLogInput(tailState, this.getTailLogSourceConfiguration().getTailLogInputConfiguration(), this.factory, this.passiveThreadPool);
                this.passiveInputs.put(tailState, input);
                this.passiveNewInputs.add(input);
            } else {
                log.debug("Adding file [{}] to active ThreadPool as it is created after initial scan; isPassiveQueueActive = [{}]; isInitialScan = [{}]", new Object[]{tailState.getFilename(), this.isPassiveQueueActive, this.inputScanner.getInitialScan() > tailState.getLastModifiedTimestamp()});
                input = new TailLogInput(tailState, this.getTailLogSourceConfiguration().getTailLogInputConfiguration(), this.factory, this.inputThreadPool);
                this.inputs.put(tailState, input);
                this.newInputs.add(input);
            }
        }
        catch (Exception except) {
            log.error(String.format("Failed to create log input [%s].", tailState.getFilename()), (Throwable)except);
        }
        return input;
    }

    private TailLogSourceConfiguration getTailLogSourceConfiguration() {
        return (TailLogSourceConfiguration)this.getConfiguration();
    }

    void startInputScanner() {
        this.initializeDirectoryPoller();
        this.initializeInputScanner();
        this.inputScannerFutureTask = new ExitTrackableFutureTask((Runnable)new InputScannerRunnable(), null);
        this.executorService.submit((Runnable)this.inputScannerFutureTask);
    }

    void stopInputScanner() {
        if (this.inputScannerFutureTask != null) {
            try {
                boolean success = ConcurrencyHelper.cancelWithWaitOnExit((ExitTrackableFutureTask)this.inputScannerFutureTask, (long)30000L);
                if (!success) {
                    log.error("Input scanner runnable failed to exit after [{}] seconds.  The scanner is being orphaned.", (Object)30L);
                }
            }
            finally {
                this.inputScannerFutureTask = null;
            }
        }
    }

    void stopPassiveInputs(boolean hardstop) {
        if (this.isPassiveQueueActive && (hardstop || this.passivePendingInputQueue.isEmpty() && this.passiveNewInputs.isEmpty() && this.passiveThreadPool.getActiveCount() == 0)) {
            this.passivePendingInputQueue.clear();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (TailLogInput input : this.passiveInputs.values()) {
                futures.add(CompletableFuture.runAsync(input.stopRunnable()));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).join();
            this.passiveInputs.clear();
            ConcurrencyHelper.stop((ExecutorService)this.passiveThreadPool, (Logger)log);
            this.isPassiveQueueActive = false;
        }
    }

    void updateNextDiscardTailingStateTime() {
        long currentTime = TimeKeeper.currentUtcTime().getMillis();
        this.updateNextDiscardTailingStateTime(currentTime);
    }

    void updateNextDiscardTailingStateTime(long baseTime) {
        this.nextDiscardTailingStateTime = baseTime + this.getTailLogSourceConfiguration().getDiscardTailingStateCheckInterval().toMilliseconds();
    }

    public TailLogWatermarkState makeTailLogWatermarkState() {
        ArrayList tailFileStates = Lists.newArrayList((Iterable)Iterables.concat(this.partialIdToTailStates.values(), this.fileIdToTailStates.values()));
        return new TailLogWatermarkState(tailFileStates);
    }

    public HealthCheck.Result check() {
        StringBuilder sb = new StringBuilder();
        boolean allRunning = true;
        int noOfOpenFiles = 0;
        for (TailLogInput input : this.inputs.values()) {
            if (input.isFileOpened()) {
                ++noOfOpenFiles;
            }
            HealthCheck.Result inputHealth = input.check();
            if (sb.length() > 0) {
                sb.append(",    ");
            }
            sb.append('[').append(inputHealth.getMessage()).append(' ').append(inputHealth.isHealthy() ? " running" : " idle").append(']');
            allRunning = allRunning && inputHealth.isHealthy();
        }
        StringBuilder fileHandlesSb = new StringBuilder();
        if (sb.length() > 0) {
            fileHandlesSb.append("No of Open Handles - ").append(noOfOpenFiles).append(" ").append((CharSequence)sb);
        }
        String msg = fileHandlesSb.length() == 0 ? (this.isEnabled() ? "idle" : "disabled") : fileHandlesSb.toString();
        return allRunning ? HealthCheck.Result.healthy((String)msg) : HealthCheck.Result.unhealthy((String)msg);
    }

    @Override
    public LogWatermarkState getWatermarkState() {
        return this.makeTailLogWatermarkState();
    }

    @Override
    public void setWatermarkState(LogWatermarkState watermarkState) {
        if (watermarkState instanceof TailLogWatermarkState) {
            TailLogWatermarkState tailLogWatermarkState = (TailLogWatermarkState)watermarkState;
            for (TailFileState tailFileState : tailLogWatermarkState.getTailFileStates()) {
                log.debug("Log file [{}] with signature [{}] resuming from last read position [{}]", new Object[]{tailFileState.getFilename(), tailFileState.getSignature().getSignature(), tailFileState.getLastReadPosition()});
                FileSignature signature = tailFileState.getSignature();
                if (signature.isComplete()) {
                    this.fileIdToTailStates.put(signature, tailFileState);
                    continue;
                }
                this.partialIdToTailStates.put(signature, tailFileState);
            }
        } else {
            throw new IllegalArgumentException("Expected TailLogWatermarkState");
        }
    }

    class InputScannerRunnable
    implements Runnable {
        InputScannerRunnable() {
        }

        @Override
        public void run() {
            try {
                long lastHardCheck = System.currentTimeMillis();
                long hardCheckInterval = TailLogSource.this.getTailLogSourceConfiguration().getHardDirectoryPollingInterval().toMilliseconds();
                while (TailLogSource.this.isRunning()) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastHardCheck > hardCheckInterval) {
                        TailLogSource.this.inputScanner.scan(true);
                        lastHardCheck = currentTime;
                    } else {
                        TailLogSource.this.inputScanner.scan(false);
                    }
                    Thread.sleep(1L);
                    TailLogSource.this.stopIdleInputs(TailLogSource.this.inputs);
                    TailLogSource.this.stopIdleInputs(TailLogSource.this.passiveInputs);
                    Thread.sleep(1L);
                    TailLogSource.this.startNewInputs(TailLogSource.this.newInputs);
                    if (TailLogSource.this.isPassiveQueueActive) {
                        if (TailLogSource.this.passiveNewInputs.isEmpty()) {
                            TailLogSource.this.stopPassiveInputs(false);
                        } else {
                            TailLogSource.this.startNewInputs(TailLogSource.this.passiveNewInputs);
                        }
                    }
                    Thread.sleep(1L);
                    TailLogSource.this.checkDiscardOldTailStates();
                    TailLogSource.this.sleepWhileRunning(TailLogSource.this.getTailLogSourceConfiguration().getDirectoryPollingInterval().toMilliseconds());
                }
            }
            catch (InterruptedException e) {
                log.info("The Thread was interrupted while tailing [{}]", (Object)TailLogSource.this.getName());
            }
            catch (Throwable t) {
                log.error("Error occurred at [{}] while scanning and tailing log sources", (Object)TailLogSource.this.getName(), (Object)t);
            }
        }
    }
}

