/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source;

import com.appdynamics.analytics.agent.base.LogBase;
import com.appdynamics.analytics.agent.source.LogComponentFactory;
import com.appdynamics.analytics.agent.source.LogSource;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.LogSourceWatermarkConfiguration;
import com.appdynamics.analytics.agent.source.LogSources;
import com.appdynamics.analytics.agent.source.tail.LogSourceState;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.concurrent.ExitTrackableFutureTask;
import com.appdynamics.common.util.configuration.Reader;
import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWatermarkManager
extends LogBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogWatermarkManager.class);
    public static final String WATERMARKS_BASE_FILENAME = "watermarks.json";
    private final JsonFactory jsonFactory;
    private final ObjectMapper objectMapper;
    private final String watermarkPath;
    @VisibleForTesting
    private final File watermarksFile;
    private boolean failedToLoadWatermark;
    private boolean failedToSaveWatermark;
    @VisibleForTesting
    private volatile ExitTrackableFutureTask<?> persistWatermarkTrackingFutureTask;
    private volatile PersistWatermarkRunnable persistWatermarkRunnable;
    private final LogSources logSources;
    private final Long watermarkPersistIntervalMillis;

    public LogWatermarkManager(LogSources logSources, LogComponentFactory logComponentFactory, ExecutorService executorService, String watermarkPath, Long watermarkPersistIntervalMillis) {
        super("Watermark Manager", logComponentFactory, executorService);
        this.logSources = logSources;
        this.watermarkPath = watermarkPath;
        this.watermarkPersistIntervalMillis = watermarkPersistIntervalMillis;
        this.jsonFactory = new JsonFactory();
        this.objectMapper = Reader.DEFAULT_JSON_MAPPER;
        this.watermarksFile = new File(watermarkPath, WATERMARKS_BASE_FILENAME);
        this.failedToLoadWatermark = false;
    }

    @Override
    public synchronized void start() {
        if (!this.isRunning()) {
            super.start();
            this.ensureWatermarksPathExists();
            this.startWriteWatermarkThread();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.isRunning()) {
            super.stop();
            this.stopWriteWatermarkThread();
            this.persistWatermarkRunnable.recordUpdatedWatermark();
        }
    }

    public HealthCheck.Result check() {
        StringBuilder sb = new StringBuilder();
        sb.append("load watermarks: ");
        sb.append(this.failedToLoadWatermark ? "failed" : "succeeded");
        sb.append(", last save watermarks: ");
        sb.append(this.failedToSaveWatermark ? "failed" : "succeeded");
        boolean isIdle = this.persistWatermarkTrackingFutureTask == null || this.persistWatermarkTrackingFutureTask.isDone() || !this.isRunning();
        sb.append(isIdle ? ", idle" : ", running");
        if (isIdle || this.failedToSaveWatermark) {
            return HealthCheck.Result.unhealthy((String)sb.toString());
        }
        sb.append(", running");
        return HealthCheck.Result.healthy((String)sb.toString());
    }

    public LogSourceWatermarkConfiguration loadWatermarks() {
        LogSourceWatermarkConfiguration sourceWatermarkConfiguration = new LogSourceWatermarkConfiguration();
        try {
            sourceWatermarkConfiguration = this.loadWatermarksFromFile(this.watermarksFile);
            this.failedToLoadWatermark = false;
        }
        catch (Exception except) {
            this.failedToLoadWatermark = true;
            String message = String.format("Failed to load source watermarks [%s] with error [%s].  This is probably the first run.", this.watermarksFile, except.getMessage());
            this.logErrorIfNotFileNotFound(except, message);
        }
        return sourceWatermarkConfiguration;
    }

    void logErrorIfNotFileNotFound(Exception except, String message) {
        if (except instanceof FileNotFoundException) {
            log.info(message);
        } else {
            log.error(message, (Throwable)except);
        }
    }

    @VisibleForTesting
    public LogSourceWatermarkConfiguration loadWatermarksFromFile(File sourceStatesFile) throws IOException {
        LogSourceWatermarkConfiguration sourceWatermarkConfiguration;
        try {
            sourceWatermarkConfiguration = (LogSourceWatermarkConfiguration)this.objectMapper.readValue(sourceStatesFile, LogSourceWatermarkConfiguration.class);
        }
        catch (Exception e) {
            sourceWatermarkConfiguration = this.loadLegacyWatermarksFile(sourceStatesFile);
        }
        return sourceWatermarkConfiguration;
    }

    private LogSourceWatermarkConfiguration loadLegacyWatermarksFile(File sourceStatesFile) throws IOException {
        JsonParser jsonParser = this.jsonFactory.createParser(sourceStatesFile);
        MappingIterator sourceStates = this.objectMapper.readValues(jsonParser, LogSourceState.class);
        TreeSet<String> permanentlyDisabled = new TreeSet<String>();
        while (sourceStates.hasNext()) {
            LogSourceConfiguration state = ((LogSourceState)sourceStates.next()).getLogSourceConfiguration();
            String jobFileId = state.getImportedFromSourceId();
            if (jobFileId == null || !state.isDisableImportedSourceId()) continue;
            permanentlyDisabled.add(jobFileId);
        }
        return new LogSourceWatermarkConfiguration(false, false, permanentlyDisabled, Lists.newArrayList((Iterator)sourceStates));
    }

    public void saveWatermarks(File sourceStatesFile) throws IOException {
        ImmutableList.Builder sourceStatesBuilder = ImmutableList.builder();
        Set<String> permanentlyDisabledConfigs = this.logSources.getConfiguration().getForcedDisabledSourceIds();
        for (LogSource source : this.logSources.getAllLogSources()) {
            LogSourceState sourceState = new LogSourceState(source.getConfiguration(), source.getWatermarkState());
            sourceStatesBuilder.add((Object)sourceState);
        }
        LogSourceWatermarkConfiguration sourceWatermarkConfiguration = new LogSourceWatermarkConfiguration(this.logSources.getConfiguration().isDisableAllLocalSources(), this.logSources.getConfiguration().isDisableAllSources(), permanentlyDisabledConfigs, (List<LogSourceState>)sourceStatesBuilder.build());
        this.saveWatermarks(sourceStatesFile, sourceWatermarkConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWatermarks(File sourceStatesFile, LogSourceWatermarkConfiguration sourceWatermarkConfiguration) throws IOException {
        try (JsonGenerator jsonGenerator = null;){
            jsonGenerator = this.jsonFactory.createGenerator(sourceStatesFile, JsonEncoding.UTF8);
            this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(jsonGenerator, (Object)sourceWatermarkConfiguration);
            jsonGenerator.flush();
        }
    }

    private void ensureWatermarksPathExists() {
        File sourcePath = new File(this.watermarkPath);
        if (!sourcePath.exists()) {
            try {
                if (!sourcePath.mkdir()) {
                    log.error("Failed to create path [{}]", (Object)sourcePath.getAbsolutePath());
                }
            }
            catch (Exception except) {
                log.error("Failed to create path [{}] because [{}]", (Object)sourcePath.getAbsolutePath(), (Object)except.getMessage());
            }
        }
    }

    @VisibleForTesting
    void startWriteWatermarkThread() {
        this.persistWatermarkRunnable = new PersistWatermarkRunnable();
        this.persistWatermarkTrackingFutureTask = new ExitTrackableFutureTask((Runnable)this.persistWatermarkRunnable, null);
        this.executorService.submit((Runnable)this.persistWatermarkTrackingFutureTask);
    }

    @VisibleForTesting
    void stopWriteWatermarkThread() {
        if (this.persistWatermarkTrackingFutureTask != null) {
            try {
                boolean success = ConcurrencyHelper.cancelWithWaitOnExit(this.persistWatermarkTrackingFutureTask, (long)30000L);
                if (!success) {
                    log.error("Watermark persistence runnable failed to exit after [{}] seconds.  The task is being orphaned.", (Object)30L);
                }
            }
            finally {
                this.persistWatermarkTrackingFutureTask = null;
            }
        }
    }

    @Generated
    public File getWatermarksFile() {
        return this.watermarksFile;
    }

    @Generated
    public ExitTrackableFutureTask<?> getPersistWatermarkTrackingFutureTask() {
        return this.persistWatermarkTrackingFutureTask;
    }

    @Generated
    public Long getWatermarkPersistIntervalMillis() {
        return this.watermarkPersistIntervalMillis;
    }

    class PersistWatermarkRunnable
    implements Runnable {
        PersistWatermarkRunnable() {
        }

        void recordUpdatedWatermark() {
            try {
                LogWatermarkManager.this.ensureWatermarksPathExists();
                LogWatermarkManager.this.saveWatermarks(LogWatermarkManager.this.watermarksFile);
                LogWatermarkManager.this.failedToSaveWatermark = false;
            }
            catch (IOException except) {
                LogWatermarkManager.this.failedToSaveWatermark = true;
                log.error(String.format("Failed to write sources watermark [%s] state successfully... not tracking watermarks!!", LogWatermarkManager.this.watermarksFile.getAbsolutePath()), (Throwable)except);
            }
        }

        @Override
        public void run() {
            while (LogWatermarkManager.this.isRunning()) {
                this.recordUpdatedWatermark();
                LogWatermarkManager.this.sleepWhileRunning(LogWatermarkManager.this.getWatermarkPersistIntervalMillis());
            }
        }
    }
}

