/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source;

import com.appdynamics.analytics.agent.input.tail.FileSignature;
import com.appdynamics.analytics.agent.input.tail.TailFileState;
import com.appdynamics.analytics.agent.pipeline.dynamic.LogSourceJobFileParser;
import com.appdynamics.analytics.agent.source.LogSource;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.LogSourceItems;
import com.appdynamics.analytics.agent.source.LogSources;
import com.appdynamics.analytics.agent.source.LogSourcesConfiguration;
import com.appdynamics.analytics.agent.source.LogWatermarkManager;
import com.appdynamics.analytics.agent.source.syslog.SyslogSource;
import com.appdynamics.analytics.agent.source.syslog.SyslogSourceConfiguration;
import com.appdynamics.analytics.agent.source.tail.DirectoryPoller;
import com.appdynamics.analytics.agent.source.tail.FileInputScanner;
import com.appdynamics.analytics.agent.source.tail.TailLogSource;
import com.appdynamics.analytics.agent.source.tail.TailLogSourceConfiguration;
import com.appdynamics.analytics.io.syslog.SyslogTcpMessageHandler;
import com.appdynamics.analytics.io.syslog.SyslogTcpServer;
import com.appdynamics.analytics.io.tcp.TcpServer;
import com.appdynamics.analytics.log.shared.dynamic.SyslogConfiguration;
import com.appdynamics.analytics.pipeline.framework.Pipeline;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.analytics.pipeline.framework.Pipelines;
import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.io.file.FilePathConfiguration;
import com.appdynamics.common.io.server.Server;
import com.appdynamics.common.io.server.Servers;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.configuration.ConfigurationHelper;
import com.appdynamics.common.util.configuration.Sanitizer;
import com.appdynamics.common.util.grok.Grok;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.item.Item;
import com.appdynamics.common.util.lifecycle.LifecycleInjector;
import com.appdynamics.common.util.lifecycle.MutableRunningState;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.netty.channel.ChannelOption;
import io.netty.handler.logging.LogLevel;
import java.net.BindException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSourcesModule
extends Module<LogSourcesConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogSourcesModule.class);

    @Provides
    @Singleton
    LogComponentFactory makeLogComponentFactory(Pipelines pipelines, Servers servers, Grok grok) {
        return new LogComponentFactory(pipelines, servers, grok, (LogSourcesConfiguration)this.getConfiguration());
    }

    @Provides
    @Singleton
    LogSources makeLogSources(LogComponentFactory factory, LogSourceJobFileParser logSourceJobFileParser, LifecycleInjector lifecycleInjector, ConsolidatedHealthCheck healthCheck) {
        ExecutorService executorService = Executors.newCachedThreadPool(ConcurrencyHelper.newDaemonThreadFactory((String)"log-sources-thread-%d"));
        LogSources logSources = new LogSources(factory, (LogSourcesConfiguration)this.getConfiguration(), logSourceJobFileParser, executorService);
        logSources = (LogSources)((Object)lifecycleInjector.inject((Object)logSources));
        healthCheck.register((HealthCheckable)logSources);
        return logSources;
    }

    @Inject
    void selfStart(LogSources logSources) {
        log.info("Started");
    }

    static class LogComponentFactory
    implements com.appdynamics.analytics.agent.source.LogComponentFactory {
        final Pipelines pipelines;
        final Servers servers;
        final Grok grok;
        final LogSourcesConfiguration logSourcesConfiguration;

        LogComponentFactory(Pipelines pipelines, Servers servers, Grok grok, LogSourcesConfiguration logSourcesConfiguration) {
            this.pipelines = pipelines;
            this.servers = servers;
            this.grok = grok;
            this.logSourcesConfiguration = logSourcesConfiguration;
        }

        @Override
        public Grok createGrok() {
            return this.grok;
        }

        @Override
        public MutableRunningState createRunningState(boolean initialValue) {
            return new MutableRunningState(initialValue);
        }

        @Override
        public Pipeline createPipeline(PipelineConfiguration pipelineConfiguration) {
            return this.pipelines.createPipeline(pipelineConfiguration);
        }

        @Override
        public DirectoryPoller createDirectoryPoller(FilePathConfiguration filePathConfiguration, boolean includeCompressedGzipFiles) {
            return new DirectoryPoller(filePathConfiguration, includeCompressedGzipFiles);
        }

        @Override
        public FileInputScanner createFileInputScanner(DirectoryPoller directoryPoller, Map<FileSignature, TailFileState> partialIdToTailStates, Map<FileSignature, TailFileState> fileIdToTailStates, Function<TailFileState, Boolean> ensureInputExists, int collectLastNHours) {
            return new FileInputScanner(directoryPoller, partialIdToTailStates, fileIdToTailStates, ensureInputExists, collectLastNHours);
        }

        @Override
        public LogSource createLogSource(LogSourceConfiguration configuration, ExecutorService executorService) throws IllegalArgumentException {
            if (configuration instanceof TailLogSourceConfiguration) {
                TailLogSourceConfiguration tailLogSourceConfiguration = (TailLogSourceConfiguration)configuration;
                return new TailLogSource(tailLogSourceConfiguration, (com.appdynamics.analytics.agent.source.LogComponentFactory)this, executorService);
            }
            if (configuration instanceof SyslogSourceConfiguration) {
                return this.newSyslogSource((SyslogSourceConfiguration)configuration, executorService);
            }
            throw new IllegalArgumentException("Unrecognized log source.");
        }

        @Override
        public LogWatermarkManager createLogWatermarkManager(LogSources logSources, ExecutorService executorService, String watermarkPath, Long watermarkPersistIntervalMillis) {
            return new LogWatermarkManager(logSources, this, executorService, watermarkPath, watermarkPersistIntervalMillis);
        }

        @Override
        public LogSourceItems createLogSourceItems(int maxRunnableSources) {
            return new LogSourceItems(maxRunnableSources);
        }

        @VisibleForTesting
        SyslogSource newSyslogSource(SyslogSourceConfiguration configuration, ExecutorService executorService) {
            int attempt;
            if (!configuration.isEnabled()) {
                return null;
            }
            String hostFromProperties = ConfigurationHelper.getProperties().getProperty("ad.dw.http.host");
            String host = Strings.isNullOrEmpty((String)(hostFromProperties = Sanitizer.sanitizeForUrl((String)hostFromProperties))) ? "localhost" : hostFromProperties;
            int port = configuration.getSyslogInputConfiguration().getSyslogConfiguration().getPort();
            SyslogConfiguration.Protocol protocol = configuration.getSyslogInputConfiguration().getSyslogConfiguration().getProtocol();
            Charset charset = Charset.forName(configuration.getSyslogInputConfiguration().getSyslogConfiguration().getCharset());
            String serverId = "syslog-" + protocol.toString().toLowerCase() + "-" + port;
            Integer maxIncomingMessageLength = this.logSourcesConfiguration.getMaxSyslogIncomingMessageLength();
            SyslogTcpMessageHandler messageHandler = maxIncomingMessageLength == null ? new SyslogTcpMessageHandler(charset) : new SyslogTcpMessageHandler(maxIncomingMessageLength, charset);
            TcpServer.Parameters<SyslogTcpMessageHandler> parameters = new TcpServer.Parameters().setId(serverId).setHostAndPort(HostAndPort.fromParts((String)host, (int)port)).setChannelOptions(new HashMap<ChannelOption<Object>, Object>()).setNumBossThreads(1).setNumWorkerThreads(1).setHandler(messageHandler).setLogLevel(LogLevel.TRACE).validate();
            Server existingOrNewServer = (Server)this.servers.get((Object)serverId);
            SyslogTcpServer createdServerThatMayNeedClose = null;
            for (attempt = 0; existingOrNewServer == null && attempt < 3; ++attempt) {
                try {
                    createdServerThatMayNeedClose = new SyslogTcpServer(parameters);
                    this.servers.add((Item)createdServerThatMayNeedClose);
                    existingOrNewServer = createdServerThatMayNeedClose;
                    break;
                }
                catch (Throwable t) {
                    if (createdServerThatMayNeedClose != null) {
                        createdServerThatMayNeedClose.close();
                        createdServerThatMayNeedClose = null;
                    }
                    if (!(Throwables.getRootCause((Throwable)t) instanceof BindException)) {
                        throw Throwables.propagate((Throwable)t);
                    }
                    log.warn("Error occurred while attempting to create server", t);
                    existingOrNewServer = (Server)this.servers.get((Object)serverId);
                    continue;
                }
            }
            if (existingOrNewServer == null) {
                throw new ConfigurationException("Unable to create server even after [" + attempt + "] attempts");
            }
            if (!(existingOrNewServer instanceof SyslogTcpServer)) {
                throw new ConfigurationException("The server registered under [" + serverId + "] is of type [" + existingOrNewServer.getClass().getName() + "] but was expected to be of type [" + SyslogTcpServer.class.getName() + "]");
            }
            SyslogTcpServer syslogServer = (SyslogTcpServer)existingOrNewServer;
            SyslogSource syslogSource = new SyslogSource(configuration, this, executorService, syslogServer, this.servers);
            if (!syslogServer.compareAndSetListener(null, syslogSource)) {
                if (createdServerThatMayNeedClose != null) {
                    createdServerThatMayNeedClose.close();
                }
                throw new ConfigurationException("A Syslog listener is already present. Only one listener at a time is supported");
            }
            return syslogSource;
        }
    }
}

