/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source;

import com.appdynamics.analytics.agent.source.LogSource;
import com.appdynamics.common.util.item.Item;
import com.appdynamics.common.util.item.Items;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSourceItems
extends Items<Object, LogSource> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogSourceItems.class);
    private final int maxRunnableSources;
    @VisibleForTesting
    private int numRunningSources;
    @VisibleForTesting
    private Map<Object, LogSource> pendingSources;
    private Predicate<LogSource> nonStartablePredicate;

    public LogSourceItems(int maxRunnableSources) {
        super("Log Sources");
        this.maxRunnableSources = maxRunnableSources;
        this.numRunningSources = 0;
        this.pendingSources = new LinkedHashMap<Object, LogSource>();
        this.nonStartablePredicate = Predicates.alwaysFalse();
    }

    public synchronized void add(LogSource logSource) {
        super.add((Item)logSource);
        if (logSource.isEnabled()) {
            this.pendingSources.put(logSource.getId(), logSource);
        }
    }

    public synchronized void addSource(LogSource logSource) {
        this.add(logSource);
    }

    public synchronized void addSource(LogSource logSource, boolean forceStart) {
        this.add(logSource);
        if (forceStart) {
            this.startSource(logSource);
        }
    }

    public synchronized LogSource getSource(String logSourceId) {
        return (LogSource)super.get((Object)logSourceId);
    }

    public synchronized Collection<LogSource> getAllLogSources() {
        return ImmutableList.copyOf((Collection)this.getAll());
    }

    public synchronized LogSource remove(Object logSourceId) {
        LogSource logSource = (LogSource)this.get(logSourceId);
        if (logSource != null) {
            this.stopSource(logSource);
            this.pendingSources.remove(logSourceId);
            super.remove(logSourceId);
        }
        return logSource;
    }

    public synchronized void removeSource(String logSourceId) {
        this.remove(logSourceId);
    }

    public synchronized void setNonStartablePredicate(Predicate<LogSource> nonStartablePredicate) {
        this.nonStartablePredicate = nonStartablePredicate;
        for (LogSource logSource : this.items.values()) {
            if (!logSource.isRunning() || !nonStartablePredicate.apply((Object)logSource)) continue;
            this.stopSource(logSource);
        }
    }

    public synchronized void startPendingSources() {
        this.startAll();
    }

    public synchronized void startAll() {
        for (LogSource logSource : ImmutableList.copyOf(this.pendingSources.values())) {
            if (logSource.isAlwaysRunnable() || this.numRunningSources < this.maxRunnableSources) {
                this.startSource(logSource);
                continue;
            }
            log.info("Maximum number of allowed log sources [{}/{}] are running. Source [{}] will remain queued for when another log source is disabled or removed.", new Object[]{this.numRunningSources, this.maxRunnableSources, logSource.getId()});
        }
    }

    public synchronized void stopAll() {
        for (LogSource logSource : this.getAll()) {
            this.stopSource(logSource);
        }
    }

    private void startSource(LogSource logSource) {
        if (logSource.isEnabled()) {
            if (!this.nonStartablePredicate.apply((Object)logSource)) {
                if (!logSource.isRunning()) {
                    logSource.start();
                    this.pendingSources.remove(logSource.getId());
                    ++this.numRunningSources;
                }
            } else {
                log.info("Skipping source [{}] because it has been marked non-startable (globally disabled).", (Object)logSource.getName());
            }
        } else {
            log.info("Skipped source [{}] because it is disabled.", (Object)logSource.getName());
        }
    }

    private void stopSource(LogSource logSource) {
        if (logSource.isRunning()) {
            logSource.stop();
            this.pendingSources.put(logSource.getId(), logSource);
            --this.numRunningSources;
        }
    }

    @Generated
    int getNumRunningSources() {
        return this.numRunningSources;
    }

    @Generated
    Map<Object, LogSource> getPendingSources() {
        return this.pendingSources;
    }
}

