/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source;

import com.appdynamics.analytics.agent.field.ExtractedFieldsManager;
import com.appdynamics.analytics.agent.input.tail.TailLogInputConfiguration;
import com.appdynamics.analytics.agent.pipeline.file.TailStageConfiguration;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.syslog.SyslogInputConfiguration;
import com.appdynamics.analytics.agent.source.syslog.SyslogSourceConfiguration;
import com.appdynamics.analytics.agent.source.tail.TailLogSourceConfiguration;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.log.shared.dynamic.SyslogConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.grok.NonGrokPattern;
import com.appdynamics.common.io.file.FilePathConfiguration;
import com.appdynamics.common.util.configuration.CommonReader;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSourceConfigurationHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogSourceConfigurationHelper.class);

    private LogSourceConfigurationHelper() {
    }

    static TailLogSourceConfiguration convertPipelineConfigurationToTailLogSourceConfiguration(Object id, PipelineConfiguration configuration, ExtractedFieldsManager extractedFieldsManager) {
        ArrayList stages = new ArrayList(configuration.getStages());
        PipelineStageConfiguration tailStage = (PipelineStageConfiguration)stages.remove(0);
        TailStageConfiguration tailStageConfiguration = (TailStageConfiguration)((Object)CommonReader.readFrom(TailStageConfiguration.class, (Object)tailStage.getProperties()));
        TailLogSourceConfiguration sourceConfiguration = new TailLogSourceConfiguration();
        sourceConfiguration.setName(id.toString());
        sourceConfiguration.setId(id.toString());
        sourceConfiguration.setEnabled(configuration.isEnabled());
        FilePathConfiguration pathConfiguration = new FilePathConfiguration();
        pathConfiguration.setPath(tailStageConfiguration.getPath());
        pathConfiguration.setNameGlob(tailStageConfiguration.getNameGlob());
        pathConfiguration.setBlacklistGlob(tailStageConfiguration.getBlacklistGlob());
        sourceConfiguration.setSourcePath(pathConfiguration);
        sourceConfiguration.setDirectoryPollingInterval(new TimeUnitConfiguration(tailStageConfiguration.getPollMillis(), TimeUnit.MILLISECONDS));
        sourceConfiguration.setHardDirectoryPollingInterval(new TimeUnitConfiguration(tailStageConfiguration.getHardPollMillis(), TimeUnit.MILLISECONDS));
        PipelineConfiguration tailLogPipeline = new PipelineConfiguration();
        tailLogPipeline.setId(configuration.getId());
        tailLogPipeline.setStages(stages);
        tailLogPipeline.setEnabled(configuration.isEnabled());
        TailLogInputConfiguration tailLogConfiguration = new TailLogInputConfiguration();
        tailLogConfiguration.setPipelineConfiguration(tailLogPipeline);
        tailLogConfiguration.setStartAtEnd(tailStageConfiguration.isStartAtEnd());
        tailLogConfiguration.setStartAtEndCreationThresholdMillis(tailStageConfiguration.getStartAtEndCreationThresholdMillis());
        tailLogConfiguration.setPathExtractedFieldsGrok(tailStageConfiguration.getPathExtractedFieldsGrok());
        sourceConfiguration.setTailLogInputConfiguration(tailLogConfiguration);
        String sourceType = LogSourceConfigurationHelper.getSourceType(configuration);
        if (sourceType == null) {
            throw new IllegalStateException(String.format("Could not find mandatory sourceType field within pipeline configuration for log source [%s]", id));
        }
        log.debug("Log source [{}] is configured to have the following source type [{}]", id, (Object)sourceType);
        sourceConfiguration.setSourceType(sourceType);
        if (configuration.isEnabled()) {
            Set<NonGrokPattern> extractedFieldPatterns = LogSourceConfigurationHelper.getNonGrokPatterns(id, sourceConfiguration, sourceType, extractedFieldsManager);
            extractedFieldsManager.addExtractedFieldPatterns(tailLogPipeline, extractedFieldPatterns);
        }
        return sourceConfiguration;
    }

    static SyslogSourceConfiguration convertPipelineConfigurationToSyslogSourceConfiguration(Object id, PipelineConfiguration configuration, ExtractedFieldsManager extractedFieldsManager) {
        ArrayList stages = new ArrayList(configuration.getStages());
        PipelineStageConfiguration syslogStage = (PipelineStageConfiguration)stages.remove(0);
        SyslogConfiguration syslogStageConfiguration = (SyslogConfiguration)CommonReader.readFrom(SyslogConfiguration.class, (Object)syslogStage.getProperties());
        SyslogSourceConfiguration sourceConfiguration = new SyslogSourceConfiguration();
        sourceConfiguration.setName(id.toString());
        sourceConfiguration.setId(id.toString());
        sourceConfiguration.setEnabled(configuration.isEnabled());
        PipelineConfiguration syslogPipeline = new PipelineConfiguration();
        syslogPipeline.setId(configuration.getId());
        syslogPipeline.setStages(stages);
        syslogPipeline.setEnabled(configuration.isEnabled());
        SyslogInputConfiguration syslogInputConfiguration = new SyslogInputConfiguration();
        syslogInputConfiguration.setPipelineConfiguration(syslogPipeline);
        syslogInputConfiguration.setSyslogConfiguration(syslogStageConfiguration);
        sourceConfiguration.setSyslogInputConfiguration(syslogInputConfiguration);
        String sourceType = LogSourceConfigurationHelper.getSourceType(configuration);
        if (sourceType == null) {
            throw new IllegalStateException(String.format("Could not find mandatory sourceType field within pipeline configuration for log source [%s]", id));
        }
        log.debug("Log source [{}] is configured to have the following source type [{}]", id, (Object)sourceType);
        sourceConfiguration.setSourceType(sourceType);
        if (configuration.isEnabled()) {
            Set<NonGrokPattern> extractedFieldPatterns = LogSourceConfigurationHelper.getNonGrokPatterns(id, sourceConfiguration, sourceType, extractedFieldsManager);
            extractedFieldsManager.addExtractedFieldPatterns(syslogPipeline, extractedFieldPatterns);
        }
        return sourceConfiguration;
    }

    public static LogSourceConfiguration convertPipelineConfigurationToLogSourceConfiguration(Object id, PipelineConfiguration pipelineConfiguration, ExtractedFieldsManager extractedFieldsManager) {
        LogSourceConfiguration logSourceConfiguration;
        String uri = ((PipelineStageConfiguration)pipelineConfiguration.getStages().get(0)).getUri();
        if (uri.equals("file:tailer")) {
            logSourceConfiguration = LogSourceConfigurationHelper.convertPipelineConfigurationToTailLogSourceConfiguration(id, pipelineConfiguration, extractedFieldsManager);
        } else if (uri.equals("syslog:listener")) {
            logSourceConfiguration = LogSourceConfigurationHelper.convertPipelineConfigurationToSyslogSourceConfiguration(id, pipelineConfiguration, extractedFieldsManager);
        } else {
            throw new IllegalStateException(String.format("Unknown log source URI detected [%s]", uri));
        }
        Object collectLastNHours = LogSourceConfigurationHelper.getPipelineStageConfigurationProperty("xform:timestampFilter", "collectLastNHours", pipelineConfiguration.getStages());
        if (collectLastNHours != null) {
            logSourceConfiguration.setCollectLastNHours(Integer.parseInt(collectLastNHours.toString()));
        }
        return logSourceConfiguration;
    }

    private static Object getPipelineStageConfigurationProperty(String stageUri, String property, List<PipelineStageConfiguration> stages) {
        for (PipelineStageConfiguration pipelineStageConfiguration : stages) {
            Map properties;
            if (!pipelineStageConfiguration.getUri().equalsIgnoreCase(stageUri) || !(properties = pipelineStageConfiguration.getProperties()).containsKey(property)) continue;
            return properties.get(property);
        }
        return null;
    }

    static Set<NonGrokPattern> getNonGrokPatterns(Object id, LogSourceConfiguration sourceConfiguration, String sourceType, ExtractedFieldsManager extractedFieldsManager) {
        Set<NonGrokPattern> extractedFieldPatterns;
        try {
            extractedFieldPatterns = extractedFieldsManager.getExtractedFieldPatterns(sourceType);
        }
        catch (RestException e) {
            log.error("Error occurred while retrieving extracted fields for sourceType [{}].", (Object)sourceType);
            throw e;
        }
        log.debug("Retrieved the following extracted field patterns {} for log source [{}]", extractedFieldPatterns, id);
        sourceConfiguration.setExtractedFieldPatterns(extractedFieldPatterns);
        return extractedFieldPatterns;
    }

    static String getSourceType(PipelineConfiguration pipelineConfiguration) {
        for (PipelineStageConfiguration stage : pipelineConfiguration.getStages()) {
            if (!"xform:field:add".equals(stage.getUri())) continue;
            return (String)stage.getProperties().get("sourceType");
        }
        return null;
    }
}

