/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.xform.json;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.common.io.NioByteArrayOutputStream;
import com.appdynamics.common.util.configuration.Reader;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Map;

public class MapsToJsonStage
extends AbstractPipelineStage<Map<Object, Object>, String> {
    final boolean clearMaps;
    final JsonFactory jsonFactory;
    final NioByteArrayOutputStream reusableBaos;

    MapsToJsonStage(PipelineStageParameters<String> parameters, boolean clearMaps) {
        super(parameters);
        this.clearMaps = clearMaps;
        this.jsonFactory = new JsonFactory((ObjectCodec)Reader.DEFAULT_JSON_MAPPER);
        this.reusableBaos = new NioByteArrayOutputStream(512);
    }

    ByteBuffer encodeToBB(Map<Object, Object> map) throws IOException {
        this.reusableBaos.reset();
        try (JsonGenerator jsonGenerator = null;){
            jsonGenerator = this.jsonFactory.createGenerator((OutputStream)this.reusableBaos, JsonEncoding.UTF8);
            jsonGenerator.writeObject(map);
            if (this.clearMaps) {
                map.clear();
            }
        }
        this.reusableBaos.close();
        return this.reusableBaos.bufferView();
    }

    String encodeToString(Map<Object, Object> map) throws IOException {
        ByteBuffer utf8Bytes = this.encodeToBB(map);
        CharBuffer charBuffer = Charsets.UTF_8.decode(utf8Bytes);
        return charBuffer.toString();
    }

    public void process(Map<Object, Object> input) {
        String json = null;
        try {
            json = this.encodeToString(input);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        this.invokeNext(json);
    }
}

