/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.event;

import com.appdynamics.analytics.agent.pipeline.event.AgentEventServiceClientModule;
import com.appdynamics.analytics.agent.pipeline.event.EventServicePublishStage;
import com.appdynamics.analytics.agent.pipeline.event.EventServicePublishStageFactoryConfig;
import com.appdynamics.analytics.agent.sync.HealthCheckHelper;
import com.appdynamics.analytics.message.api.MessagePack;
import com.appdynamics.analytics.pipeline.api.PipelineStage;
import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStageFactory;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.health.MeteredHealthCheck;
import com.google.inject.Inject;
import io.dropwizard.core.setup.Environment;
import javax.annotation.PostConstruct;

public class EventServicePublishStageFactory
extends AbstractPipelineStageFactory<MessagePack<String, String>, MessagePack<String, String>, EventServicePublishStageFactoryConfig, Object> {
    @Inject
    private volatile Environment environment;
    @Inject
    private volatile AgentEventServiceClientModule.EventServiceClientFactory clientFactory;
    @Inject
    private volatile ConsolidatedHealthCheck healthCheck;
    private volatile MeteredHealthCheck meteredHealthCheck;

    @PostConstruct
    void start() {
        this.meteredHealthCheck = new MeteredHealthCheck(this.getUri(), this.environment, (successRate, errorRate) -> HealthCheckHelper.isHealthy(errorRate));
        this.healthCheck.register((HealthCheckable)this.meteredHealthCheck);
    }

    public PipelineStage<MessagePack<String, String>, MessagePack<String, String>> create(PipelineStageParameters<MessagePack<String, String>> parameters) {
        EventServicePublishStageFactoryConfig configuration = (EventServicePublishStageFactoryConfig)this.getConfiguration();
        return new EventServicePublishStage(parameters, configuration, this.meteredHealthCheck, this.clientFactory.createEventServiceClient(), this.clientFactory.getAccountName(), this.clientFactory.getAccessKey());
    }
}

