/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.event;

import com.appdynamics.common.util.configuration.ManualValidateable;
import com.appdynamics.common.util.configuration.ManualValidated;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.URL;

@ManualValidated
public class AgentEventServiceConfiguration
implements ManualValidateable {
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 30000;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MILLIS = 30000;
    private static final String SAME_TRUSTSTORE_ERROR_MESSAGE = String.format("The Event Service's trust store cannot be provided when the property to use the Controller's trust store is also set to 'true'.", new Object[0]);
    @NotEmpty
    @URL
    String endpoint;
    @NotEmpty
    String accountName;
    @NotEmpty
    String accessKey;
    String proxyHost;
    Integer proxyPort;
    String proxyUsername;
    String proxyPassword;
    @Min(value=1000L)
    @Min(value=1000L) int socketTimeoutMillis = 30000;
    @Min(value=1000L)
    @Min(value=1000L) int connectionTimeoutMillis = 30000;
    private boolean useControllerTrustStore;
    private String eventTlsVersion;
    private String eventTrustStorePath;
    private String eventTrustStorePassword;
    private String eventTrustStoreType;
    private String controllerTrustStorePath;
    private String controllerTrustStoreType;
    private String controllerTrustStorePassword;

    public boolean validate(ConstraintValidatorContext context) {
        if (this.useControllerTrustStore) {
            if (StringUtils.isNotBlank((CharSequence)this.eventTrustStorePath)) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(SAME_TRUSTSTORE_ERROR_MESSAGE).addPropertyNode("eventTrustStorePath").addConstraintViolation();
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)this.eventTrustStorePassword)) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(SAME_TRUSTSTORE_ERROR_MESSAGE).addPropertyNode("eventTrustStorePassword").addConstraintViolation();
                return false;
            }
        }
        return true;
    }

    @Generated
    public AgentEventServiceConfiguration() {
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    @Generated
    public String getAccessKey() {
        return this.accessKey;
    }

    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Generated
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Generated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Generated
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Generated
    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    @Generated
    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Generated
    public boolean isUseControllerTrustStore() {
        return this.useControllerTrustStore;
    }

    @Generated
    public String getEventTlsVersion() {
        return this.eventTlsVersion;
    }

    @Generated
    public String getEventTrustStorePath() {
        return this.eventTrustStorePath;
    }

    @Generated
    public String getEventTrustStorePassword() {
        return this.eventTrustStorePassword;
    }

    @Generated
    public String getEventTrustStoreType() {
        return this.eventTrustStoreType;
    }

    @Generated
    public String getControllerTrustStorePath() {
        return this.controllerTrustStorePath;
    }

    @Generated
    public String getControllerTrustStoreType() {
        return this.controllerTrustStoreType;
    }

    @Generated
    public String getControllerTrustStorePassword() {
        return this.controllerTrustStorePassword;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    @Generated
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Generated
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Generated
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Generated
    public void setSocketTimeoutMillis(int socketTimeoutMillis) {
        this.socketTimeoutMillis = socketTimeoutMillis;
    }

    @Generated
    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    @Generated
    public void setUseControllerTrustStore(boolean useControllerTrustStore) {
        this.useControllerTrustStore = useControllerTrustStore;
    }

    @Generated
    public void setEventTlsVersion(String eventTlsVersion) {
        this.eventTlsVersion = eventTlsVersion;
    }

    @Generated
    public void setEventTrustStorePath(String eventTrustStorePath) {
        this.eventTrustStorePath = eventTrustStorePath;
    }

    @Generated
    public void setEventTrustStorePassword(String eventTrustStorePassword) {
        this.eventTrustStorePassword = eventTrustStorePassword;
    }

    @Generated
    public void setEventTrustStoreType(String eventTrustStoreType) {
        this.eventTrustStoreType = eventTrustStoreType;
    }

    @Generated
    public void setControllerTrustStorePath(String controllerTrustStorePath) {
        this.controllerTrustStorePath = controllerTrustStorePath;
    }

    @Generated
    public void setControllerTrustStoreType(String controllerTrustStoreType) {
        this.controllerTrustStoreType = controllerTrustStoreType;
    }

    @Generated
    public void setControllerTrustStorePassword(String controllerTrustStorePassword) {
        this.controllerTrustStorePassword = controllerTrustStorePassword;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentEventServiceConfiguration)) {
            return false;
        }
        AgentEventServiceConfiguration other = (AgentEventServiceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSocketTimeoutMillis() != other.getSocketTimeoutMillis()) {
            return false;
        }
        if (this.getConnectionTimeoutMillis() != other.getConnectionTimeoutMillis()) {
            return false;
        }
        if (this.isUseControllerTrustStore() != other.isUseControllerTrustStore()) {
            return false;
        }
        Integer this$proxyPort = this.getProxyPort();
        Integer other$proxyPort = other.getProxyPort();
        if (this$proxyPort == null ? other$proxyPort != null : !((Object)this$proxyPort).equals(other$proxyPort)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        String this$proxyUsername = this.getProxyUsername();
        String other$proxyUsername = other.getProxyUsername();
        if (this$proxyUsername == null ? other$proxyUsername != null : !this$proxyUsername.equals(other$proxyUsername)) {
            return false;
        }
        String this$proxyPassword = this.getProxyPassword();
        String other$proxyPassword = other.getProxyPassword();
        if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) {
            return false;
        }
        String this$eventTlsVersion = this.getEventTlsVersion();
        String other$eventTlsVersion = other.getEventTlsVersion();
        if (this$eventTlsVersion == null ? other$eventTlsVersion != null : !this$eventTlsVersion.equals(other$eventTlsVersion)) {
            return false;
        }
        String this$eventTrustStorePath = this.getEventTrustStorePath();
        String other$eventTrustStorePath = other.getEventTrustStorePath();
        if (this$eventTrustStorePath == null ? other$eventTrustStorePath != null : !this$eventTrustStorePath.equals(other$eventTrustStorePath)) {
            return false;
        }
        String this$eventTrustStorePassword = this.getEventTrustStorePassword();
        String other$eventTrustStorePassword = other.getEventTrustStorePassword();
        if (this$eventTrustStorePassword == null ? other$eventTrustStorePassword != null : !this$eventTrustStorePassword.equals(other$eventTrustStorePassword)) {
            return false;
        }
        String this$eventTrustStoreType = this.getEventTrustStoreType();
        String other$eventTrustStoreType = other.getEventTrustStoreType();
        if (this$eventTrustStoreType == null ? other$eventTrustStoreType != null : !this$eventTrustStoreType.equals(other$eventTrustStoreType)) {
            return false;
        }
        String this$controllerTrustStorePath = this.getControllerTrustStorePath();
        String other$controllerTrustStorePath = other.getControllerTrustStorePath();
        if (this$controllerTrustStorePath == null ? other$controllerTrustStorePath != null : !this$controllerTrustStorePath.equals(other$controllerTrustStorePath)) {
            return false;
        }
        String this$controllerTrustStoreType = this.getControllerTrustStoreType();
        String other$controllerTrustStoreType = other.getControllerTrustStoreType();
        if (this$controllerTrustStoreType == null ? other$controllerTrustStoreType != null : !this$controllerTrustStoreType.equals(other$controllerTrustStoreType)) {
            return false;
        }
        String this$controllerTrustStorePassword = this.getControllerTrustStorePassword();
        String other$controllerTrustStorePassword = other.getControllerTrustStorePassword();
        return !(this$controllerTrustStorePassword == null ? other$controllerTrustStorePassword != null : !this$controllerTrustStorePassword.equals(other$controllerTrustStorePassword));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentEventServiceConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSocketTimeoutMillis();
        result = result * 59 + this.getConnectionTimeoutMillis();
        result = result * 59 + (this.isUseControllerTrustStore() ? 79 : 97);
        Integer $proxyPort = this.getProxyPort();
        result = result * 59 + ($proxyPort == null ? 43 : ((Object)$proxyPort).hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        String $proxyUsername = this.getProxyUsername();
        result = result * 59 + ($proxyUsername == null ? 43 : $proxyUsername.hashCode());
        String $proxyPassword = this.getProxyPassword();
        result = result * 59 + ($proxyPassword == null ? 43 : $proxyPassword.hashCode());
        String $eventTlsVersion = this.getEventTlsVersion();
        result = result * 59 + ($eventTlsVersion == null ? 43 : $eventTlsVersion.hashCode());
        String $eventTrustStorePath = this.getEventTrustStorePath();
        result = result * 59 + ($eventTrustStorePath == null ? 43 : $eventTrustStorePath.hashCode());
        String $eventTrustStorePassword = this.getEventTrustStorePassword();
        result = result * 59 + ($eventTrustStorePassword == null ? 43 : $eventTrustStorePassword.hashCode());
        String $eventTrustStoreType = this.getEventTrustStoreType();
        result = result * 59 + ($eventTrustStoreType == null ? 43 : $eventTrustStoreType.hashCode());
        String $controllerTrustStorePath = this.getControllerTrustStorePath();
        result = result * 59 + ($controllerTrustStorePath == null ? 43 : $controllerTrustStorePath.hashCode());
        String $controllerTrustStoreType = this.getControllerTrustStoreType();
        result = result * 59 + ($controllerTrustStoreType == null ? 43 : $controllerTrustStoreType.hashCode());
        String $controllerTrustStorePassword = this.getControllerTrustStorePassword();
        result = result * 59 + ($controllerTrustStorePassword == null ? 43 : $controllerTrustStorePassword.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AgentEventServiceConfiguration(endpoint=" + this.getEndpoint() + ", accountName=" + this.getAccountName() + ", accessKey=" + this.getAccessKey() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", proxyUsername=" + this.getProxyUsername() + ", proxyPassword=" + this.getProxyPassword() + ", socketTimeoutMillis=" + this.getSocketTimeoutMillis() + ", connectionTimeoutMillis=" + this.getConnectionTimeoutMillis() + ", useControllerTrustStore=" + this.isUseControllerTrustStore() + ", eventTlsVersion=" + this.getEventTlsVersion() + ", eventTrustStorePath=" + this.getEventTrustStorePath() + ", eventTrustStorePassword=" + this.getEventTrustStorePassword() + ", eventTrustStoreType=" + this.getEventTrustStoreType() + ", controllerTrustStorePath=" + this.getControllerTrustStorePath() + ", controllerTrustStoreType=" + this.getControllerTrustStoreType() + ", controllerTrustStorePassword=" + this.getControllerTrustStorePassword() + ")";
    }
}

