/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.dynamic;

import com.appdynamics.analytics.agent.pipeline.dynamic.LogSourceJobFileParser;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.LogSources;
import java.io.File;
import lombok.Generated;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSourceJobFileListener
extends FileAlterationListenerAdaptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogSourceJobFileListener.class);
    private final LogSourceJobFileParser jobFileParser;
    private final LogSources logSources;

    LogSourceJobFileListener(LogSources sources, LogSourceJobFileParser jobFileParser) {
        this.logSources = sources;
        this.jobFileParser = jobFileParser;
    }

    public void onFileCreate(File file) {
        log.debug("File [{}] was created", (Object)file.getAbsolutePath());
        this.upsert(file);
    }

    public void onFileChange(File file) {
        log.debug("File [{}] was modified", (Object)file.getAbsolutePath());
        this.upsert(file);
    }

    public void onFileDelete(File file) {
        log.debug("File [{}] was deleted", (Object)file.getAbsolutePath());
        this.delete(file.getName());
    }

    private void upsert(File input) {
        try {
            LogSourceConfiguration logSourceConfiguration = this.jobFileParser.parseLogSourceConfigurationFromFile(input);
            this.logSources.upsertSource(logSourceConfiguration, false);
        }
        catch (Exception e) {
            log.error("Error occurred while processing file [{}]", (Object)input.getAbsolutePath(), (Object)e);
        }
    }

    private void delete(String logSourceId) {
        this.logSources.removeSource(logSourceId);
    }
}

