/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.dynamic;

import com.appdynamics.analytics.log.shared.dynamic.DslConfiguration;
import com.appdynamics.analytics.log.shared.dynamic.DslConfigurationV2;
import com.appdynamics.analytics.log.shared.dynamic.GenericJobConfiguration;
import com.appdynamics.analytics.log.shared.dynamic.TemplateConfiguration;
import com.appdynamics.analytics.log.shared.dynamic.TemplateConfigurationV2;
import com.appdynamics.common.util.configuration.CommonReader;
import com.appdynamics.common.util.configuration.Reader;
import com.github.mustachejava.Mustache;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobConfigurationDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobConfigurationDecoder.class);
    final Mustache mustache;

    JobConfigurationDecoder(Mustache mustache) {
        this.mustache = mustache;
    }

    InputStream toYml(File jobFile) {
        try {
            Object templateConfig = JobConfigurationDecoder.decodeStep1(jobFile);
            log.debug("File [{}] was used to produce\n{}", (Object)jobFile.getAbsolutePath(), templateConfig);
            String yml = this.decodeStep2(templateConfig);
            return new ByteArrayInputStream(yml.getBytes(Charsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static Object decodeStep1(File jobFile) throws IOException {
        GenericJobConfiguration generic = (GenericJobConfiguration)Reader.DEFAULT_YAML_MAPPER.readValue(jobFile, GenericJobConfiguration.class);
        switch (generic.getVersion()) {
            case 1: {
                DslConfiguration configV1 = (DslConfiguration)Reader.DEFAULT_YAML_MAPPER.readValue(jobFile, DslConfiguration.class);
                CommonReader.validate((Object)configV1);
                TemplateConfiguration template = TemplateConfiguration.from((DslConfiguration)configV1);
                CommonReader.validate((Object)template);
                return template;
            }
            case 2: {
                DslConfigurationV2 configV2 = (DslConfigurationV2)Reader.DEFAULT_YAML_MAPPER.readValue(jobFile, DslConfigurationV2.class);
                CommonReader.validate((Object)configV2);
                TemplateConfigurationV2 template = TemplateConfigurationV2.from((DslConfigurationV2)configV2);
                CommonReader.validate((Object)template);
                return template;
            }
        }
        throw new IllegalArgumentException("The current job configuration version is [" + generic.getVersion() + "] but the supported versions are [1] or [2]");
    }

    private <T> String decodeStep2(T templateInput) throws IOException {
        String transformedYml;
        try (StringWriter transformedYmlWriter = new StringWriter();){
            this.mustache.execute((Writer)transformedYmlWriter, templateInput).flush();
            transformedYml = transformedYmlWriter.toString();
        }
        return transformedYml;
    }
}

