/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.input.tail;

import com.appdynamics.analytics.agent.input.LogInput;
import com.appdynamics.analytics.agent.input.tail.TailFileState;
import com.appdynamics.analytics.agent.input.tail.TailLogInputConfiguration;
import com.appdynamics.analytics.agent.source.LogComponentFactory;
import com.appdynamics.analytics.pipeline.framework.Pipeline;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineStageConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelinesHealthCheck;
import com.appdynamics.analytics.pipeline.xform.grok.GrokUtils;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.concurrent.ExitTrackableFutureTask;
import com.appdynamics.common.util.grok.Grok;
import com.appdynamics.common.util.priority.PriorityRunnable;
import com.appdynamics.common.util.regex.RegexConstants;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TailLogInput
extends LogInput {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TailLogInput.class);
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    public static final String GREEDYDATA = "%{GREEDYDATA}";
    public static final int READ_BUFFSIZE_BYTES = 65536;
    public static final long ACTIVITY_TIMESTAMP_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(30000L) / RegexConstants.TIMEOUT_THRESHOLD_NANOS - 1L;
    private final AtomicBoolean tailing;
    private final AtomicBoolean failed;
    private final AtomicLong lastActivityTimestamp;
    private final TailLogInputConfiguration inputConfiguration;
    private final LogTailer logTailer;
    private volatile ExitTrackableFutureTask logTailerFutureTask;

    public TailLogInput(TailFileState tailState, TailLogInputConfiguration configuration, LogComponentFactory factory, ExecutorService executorService) {
        super("Tail Log Input:" + tailState.getFilename(), factory, executorService);
        log.info("Initiating Tail Log Input [{}]", (Object)tailState.getFilename());
        this.tailing = new AtomicBoolean(false);
        this.failed = new AtomicBoolean(false);
        this.lastActivityTimestamp = new AtomicLong(System.currentTimeMillis());
        this.inputConfiguration = configuration;
        this.logTailer = new LogTailer(tailState, configuration, factory);
    }

    public boolean isTailing() {
        return this.tailing.get();
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public TailFileState getTailState() {
        return this.getLogTailer().getTailState();
    }

    public long getLastActivityTimestamp() {
        return this.lastActivityTimestamp.get();
    }

    public HealthCheck.Result check() {
        boolean tailerHealthy;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTailState().getFilename()).append(' ');
        PipelinesHealthCheck.printStatus(this.getLogTailer().getPipeline(), (StringBuilder)sb);
        boolean bl = tailerHealthy = this.isRunning() && this.logTailerFutureTask != null;
        if (tailerHealthy) {
            tailerHealthy &= this.isLogTailingHealthy() || this.isLogIdlingHealthy();
        }
        return tailerHealthy ? HealthCheck.Result.healthy((String)sb.toString()) : HealthCheck.Result.unhealthy((String)sb.toString());
    }

    private boolean isLogTailingHealthy() {
        return this.isTailing() && !this.logTailerFutureTask.isDone();
    }

    private boolean isLogIdlingHealthy() {
        return !this.isTailing() && this.logTailerFutureTask.isDone() && !this.failed.get();
    }

    public boolean isFileOpened() {
        return this.getLogTailer().getFileChannel() != null;
    }

    @Override
    public synchronized void start() {
        if (!this.isRunning()) {
            super.start();
            this.lastActivityTimestamp.set(System.currentTimeMillis());
            this.logTailerFutureTask = (ExitTrackableFutureTask)this.executorService.submit((Runnable)((Object)this.logTailer));
        }
    }

    @Override
    public synchronized void stop() {
        CompletableFuture.allOf(CompletableFuture.runAsync(this.stopRunnable())).join();
    }

    public synchronized Runnable stopRunnable() {
        super.stop();
        return () -> {
            block7: {
                if (this.isRunning()) {
                    try {
                        if (this.logTailerFutureTask == null) break block7;
                        try {
                            this.logTailerFutureTask.waitOnRunnableExit(15000L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            log.error("Failed to stop input [{}]", (Object)this.getName(), (Object)e);
                        }
                        ConcurrencyHelper.cancelWithWaitOnExit((ExitTrackableFutureTask)this.logTailerFutureTask, (long)15000L);
                        if (!this.logTailerFutureTask.isCancelled()) {
                            log.error("Log tailer failed to stop tailing after [{}] seconds.  The tailer is orphaned, this may result in double collection.", (Object)30L);
                        }
                    }
                    finally {
                        this.logTailerFutureTask = null;
                        this.logTailer.releaseResources();
                    }
                }
            }
        };
    }

    public synchronized void releaseResources() {
        this.logTailer.releaseResources();
    }

    public static void addPathExtractedFieldsGrokToAdditionStage(Grok grok, PipelineConfiguration pipelineConfiguration, String fileName, String pathExtractedFieldsGrok) {
        Map addFieldsMap = !Strings.isNullOrEmpty((String)pathExtractedFieldsGrok) ? GrokUtils.getFieldsExtractedFromString((String)fileName, (String)pathExtractedFieldsGrok, (Grok)grok) : new HashMap();
        addFieldsMap.put("source", fileName);
        TailLogInput.addFieldValuesToAddStagePipeline(pipelineConfiguration, addFieldsMap);
    }

    public static void addFieldValuesToAddStagePipeline(PipelineConfiguration pipelineConfiguration, Map<String, Object> addFieldValues) {
        TailLogInput.addToPipelineStageConfiguration(pipelineConfiguration, "xform:field:add", addFieldValues);
    }

    public static void addToPipelineStageConfiguration(PipelineConfiguration pipelineConfiguration, String stageUri, Map<String, Object> addParameters) {
        boolean stageExists = false;
        if (pipelineConfiguration != null) {
            List stageConfigs = pipelineConfiguration.getStages();
            for (PipelineStageConfiguration stageConfig : stageConfigs) {
                if (!stageConfig.getUri().equals(stageUri)) continue;
                stageExists = true;
                if (stageConfig.getProperties() != null) {
                    for (Map.Entry<String, Object> entry : addParameters.entrySet()) {
                        stageConfig.getProperties().put(entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                log.error("The [{}] stage has not been initialized.", (Object)stageConfig.getUri());
            }
            if (!stageExists) {
                throw new RuntimeException(String.format("The stage with uri [%s] does not exist in the pipeline.", "xform:field:add"));
            }
        }
    }

    @Generated
    public LogTailer getLogTailer() {
        return this.logTailer;
    }

    class LogTailer
    extends PriorityRunnable {
        private static final long INFORMATIVE_LOG_INTERVAL_MILLIS = 30000L;
        private static final char NEW_LINE_CHAR = '\n';
        private static final char CARRIAGE_RETURN = '\r';
        private final byte[] readBuffer;
        private FileChannel fileChannel;
        private final Pipeline<CharSequence> pipeline;
        private volatile TailFileState tailState;
        private int start;
        private int startReadPosition;
        private int bufferReadPosition;
        private boolean capRemainderOfLine;
        private long lastInformativeLogUpdateMillis;
        private long lastInformativeLogBytesSoFar;

        private LogTailer(TailFileState tailFileState, TailLogInputConfiguration configuration, LogComponentFactory factory) {
            super(-1L * tailFileState.getLastModifiedTimestamp());
            this.readBuffer = new byte[65536];
            this.start = 0;
            this.startReadPosition = 0;
            this.bufferReadPosition = 0;
            this.capRemainderOfLine = false;
            this.lastInformativeLogUpdateMillis = 0L;
            this.lastInformativeLogBytesSoFar = 0L;
            this.tailState = tailFileState;
            String pathExtractedFieldsGrok = configuration.pathExtractedFieldsGrok;
            PipelineConfiguration pipelineConfig = configuration.getPipelineConfiguration();
            Grok grok = factory.createGrok();
            TailLogInput.addPathExtractedFieldsGrokToAdditionStage(grok, pipelineConfig, tailFileState.getFilename(), pathExtractedFieldsGrok);
            this.pipeline = factory.createPipeline(pipelineConfig);
        }

        public void run() {
            try {
                this.fileChannel = this.tailState.takeFileChannelOwnership();
                TailLogInput.this.failed.set(false);
                TailLogInput.this.tailing.set(true);
                log.info("Starting to tail file [{}]", (Object)this.tailState.getFilename());
                if (this.tailState.getLastReadPosition() > 0L) {
                    log.info("Resuming tailer from last read byte [{}] position", (Object)this.tailState.getLastReadPosition());
                }
                this.pipeline.start();
                this.readLogFile();
            }
            catch (Throwable e) {
                Throwable cause = Throwables.getRootCause((Throwable)e);
                if (cause instanceof InterruptedException) {
                    if (log.isDebugEnabled()) {
                        log.debug("Tailing of file [{}] with signature [{}] at last read byte [{}] position has been interrupted", new Object[]{this.tailState.getFilename(), this.tailState.getSignature(), this.tailState.getLastReadPosition(), e});
                    } else {
                        log.info("Tailing of file [{}] with signature [{}] at last read byte [{}] position has been interrupted", new Object[]{this.tailState.getFilename(), this.tailState.getSignature(), this.tailState.getLastReadPosition()});
                    }
                } else {
                    log.error("Error occurred while tailing file [{}] with signature [{}] at last read byte [{}] position", new Object[]{this.tailState.getFilename(), this.tailState.getSignature(), this.tailState.getLastReadPosition(), e});
                }
                TailLogInput.this.failed.set(true);
            }
            finally {
                this.flushAndShutdownPipeline();
                this.releaseResources();
                log.info("Stopped tailing file [{}] at last read byte [{}] position", (Object)this.tailState.getFilename(), (Object)this.tailState.getLastReadPosition());
            }
        }

        private void releaseResources() {
            if (this.fileChannel != null) {
                try {
                    this.fileChannel.close();
                }
                catch (Throwable e) {
                    log.error("Failed to close file channel for [{}]", (Object)this.tailState.getFilename(), (Object)e);
                }
                this.fileChannel = null;
            }
            TailLogInput.this.tailing.set(false);
        }

        private void flushAndShutdownPipeline() {
            log.debug("About to flush contents");
            try {
                this.pipeline.managedCall(null);
                if (Thread.currentThread().isInterrupted()) {
                    log.warn("The contents may not have been flushed completely");
                } else {
                    log.debug("The contents were flushed successfully");
                }
            }
            catch (Exception e) {
                log.warn("The contents could not be flushed completely, so there may be some data loss for the input [" + this.tailState.getFilename() + "] pipeline", (Throwable)e);
            }
            finally {
                this.pipeline.stop();
            }
        }

        private void readLogFile() throws IOException {
            TailLogInput.this.lastActivityTimestamp.set(System.currentTimeMillis());
            if (this.fileChannel == null) {
                log.error("Unable to read file [{}] because file handle was not found", (Object)this.tailState.getFilename());
                throw new IllegalStateException();
            }
            long readPosition = this.getSeekPosition();
            this.fileChannel.position(readPosition);
            this.tailState.setLastReadPosition(readPosition);
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.readBuffer);
            while (TailLogInput.this.isRunning()) {
                int bytesReadSoFar = 0;
                byteBuffer.position(this.bufferReadPosition);
                int bytesRead = this.fileChannel.read(byteBuffer);
                if (bytesRead > 0) {
                    this.bufferReadPosition += bytesRead;
                    this.tryProcessBufferIntoLines();
                }
                if ((bytesReadSoFar = bytesRead) <= 0) {
                    TailLogInput.this.sleepWhileRunning(TailLogInput.this.inputConfiguration.getTailInterval().toMilliseconds());
                    log.trace("Reading the log file [{}] after [{}] ms from last read position [{}]", new Object[]{this.tailState.getFilename(), TailLogInput.this.inputConfiguration.getTailInterval().getTime(), this.tailState.getLastReadPosition()});
                    continue;
                }
                long now = System.currentTimeMillis();
                this.tailState.setLastReadTimestamp(now);
                TailLogInput.this.lastActivityTimestamp.set(now);
                Thread.yield();
                this.lastInformativeLogBytesSoFar += (long)bytesReadSoFar;
                long timeSinceLastInformativeLog = System.currentTimeMillis() - this.lastInformativeLogUpdateMillis;
                if (timeSinceLastInformativeLog <= 30000L) continue;
                log.info("TailInput [{}] reads [{}] bytes, last read position in file [{}]", new Object[]{this.tailState.getFilename(), this.lastInformativeLogBytesSoFar, this.tailState.getLastReadPosition()});
                this.lastInformativeLogUpdateMillis = System.currentTimeMillis();
                this.lastInformativeLogBytesSoFar = 0L;
            }
        }

        private long getSeekPosition() throws IOException {
            long timeSinceCreationMillis = System.currentTimeMillis() - this.tailState.getCreated();
            if (TailLogInput.this.inputConfiguration.isStartAtEnd() && timeSinceCreationMillis > TailLogInput.this.inputConfiguration.getStartAtEndCreationThresholdMillis() && this.tailState.getLastReadPosition() == 0L) {
                byte curChar;
                long logFileLength = this.fileChannel.size();
                if (logFileLength == 0L) {
                    return 0L;
                }
                long readOffset = logFileLength < 65536L ? 0L : logFileLength - 65536L;
                this.fileChannel.position(readOffset);
                int numBytes = this.fileChannel.read(ByteBuffer.wrap(this.readBuffer));
                int count = 0;
                while (numBytes-- > 0 && (curChar = this.readBuffer[numBytes]) != 10 && curChar != 13) {
                    ++count;
                }
                if (numBytes > 0) {
                    return logFileLength - (long)count;
                }
                return logFileLength;
            }
            return this.tailState.getLastReadPosition();
        }

        private void tryProcessBufferIntoLines() throws UnsupportedEncodingException {
            int current;
            int end = this.bufferReadPosition;
            int updateActivityTimestampCounter = 0;
            for (current = this.startReadPosition; current < end; ++current) {
                byte curChar = this.readBuffer[current];
                if (curChar != 10 && curChar != 13) continue;
                int lineLength = current - this.start;
                if (this.capRemainderOfLine) {
                    this.capRemainderOfLine = false;
                } else {
                    this.processLogLine(this.start, lineLength);
                    ++updateActivityTimestampCounter;
                }
                if ((long)updateActivityTimestampCounter == ACTIVITY_TIMESTAMP_THRESHOLD) {
                    TailLogInput.this.lastActivityTimestamp.set(System.currentTimeMillis());
                    updateActivityTimestampCounter = 0;
                }
                this.increaseLastReadPosition(lineLength + 1);
                this.start = current + 1;
            }
            this.startReadPosition = current;
            if (end == this.readBuffer.length) {
                if (this.start == 0) {
                    if (!this.capRemainderOfLine) {
                        this.processLogLine(0, end);
                        this.capRemainderOfLine = true;
                    }
                    this.increaseLastReadPosition(end);
                    this.bufferReadPosition = 0;
                } else if (this.start == end) {
                    this.start = 0;
                    this.bufferReadPosition = 0;
                } else {
                    System.arraycopy(this.readBuffer, this.start, this.readBuffer, 0, end - this.start);
                    this.bufferReadPosition = end - this.start;
                    this.start = 0;
                }
                this.startReadPosition = 0;
            }
        }

        private void processLogLine(int offset, int length) throws UnsupportedEncodingException {
            if (length > 0) {
                String logLine = new String(this.readBuffer, offset, length, DEFAULT_CHARSET);
                this.pipeline.managedCall((Object)logLine);
            }
        }

        private void increaseLastReadPosition(int incr) {
            this.tailState.setLastReadPosition(this.tailState.getLastReadPosition() + (long)incr);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogTailer)) {
                return false;
            }
            LogTailer other = (LogTailer)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.start != other.start) {
                return false;
            }
            if (this.startReadPosition != other.startReadPosition) {
                return false;
            }
            if (this.bufferReadPosition != other.bufferReadPosition) {
                return false;
            }
            if (this.capRemainderOfLine != other.capRemainderOfLine) {
                return false;
            }
            if (this.lastInformativeLogUpdateMillis != other.lastInformativeLogUpdateMillis) {
                return false;
            }
            return this.lastInformativeLogBytesSoFar == other.lastInformativeLogBytesSoFar;
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LogTailer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.start;
            result = result * 59 + this.startReadPosition;
            result = result * 59 + this.bufferReadPosition;
            result = result * 59 + (this.capRemainderOfLine ? 79 : 97);
            long $lastInformativeLogUpdateMillis = this.lastInformativeLogUpdateMillis;
            result = result * 59 + (int)($lastInformativeLogUpdateMillis >>> 32 ^ $lastInformativeLogUpdateMillis);
            long $lastInformativeLogBytesSoFar = this.lastInformativeLogBytesSoFar;
            result = result * 59 + (int)($lastInformativeLogBytesSoFar >>> 32 ^ $lastInformativeLogBytesSoFar);
            return result;
        }

        @Generated
        public FileChannel getFileChannel() {
            return this.fileChannel;
        }

        @Generated
        public Pipeline<CharSequence> getPipeline() {
            return this.pipeline;
        }

        @Generated
        public TailFileState getTailState() {
            return this.tailState;
        }
    }
}

