/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.input.tail;

import com.appdynamics.analytics.agent.input.tail.FileSignature;
import com.appdynamics.analytics.agent.input.tail.GZIPFileChannel;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import lombok.Generated;

public class FileInfo
implements AutoCloseable {
    volatile FileChannel fileChannel;
    @NotNull
    String filename;
    volatile long size;
    volatile long decompressedSize;
    volatile long created;
    volatile long lastModified;
    private volatile FileSignature signature;

    public FileInfo(String filePath, BasicFileAttributes attr) {
        this(filePath, attr.size(), attr.creationTime().toMillis(), attr.lastModifiedTime().toMillis());
    }

    public FileInfo(String filename, long size, long created, long lastModified) {
        this.filename = filename;
        this.size = size;
        this.decompressedSize = -1L;
        this.created = created;
        this.lastModified = lastModified;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public FileSignature getFileSignature() throws IOException {
        return this.getFileSignature(0, 4096);
    }

    public FileSignature getFileSignature(int size) throws IOException {
        return this.getFileSignature(size, size);
    }

    public FileSignature getFileSignature(int minSize, int maxSize) throws IOException {
        if (this.signature != null && minSize <= 4096 && 4096 <= maxSize) {
            return this.signature;
        }
        FileSignature newSignature = this.getFileSignatureFromFile(minSize, maxSize);
        if (newSignature.isComplete()) {
            this.signature = newSignature;
        }
        return newSignature;
    }

    public boolean isCompressed() {
        return this.filename.endsWith(".gz");
    }

    public long getDecompressedSize() throws IOException {
        if (this.decompressedSize < 0L) {
            this.ensureFileChannelExists();
            this.decompressedSize = this.fileChannel.size();
        }
        return this.decompressedSize;
    }

    protected FileSignature getFileSignatureFromFile(int minSize, int maxSize) throws IOException {
        this.ensureFileChannelExists();
        FileSignature fileSignature = FileSignature.calculateFileSignature(this.filename, this.fileChannel, minSize, maxSize);
        this.close();
        return fileSignature;
    }

    private void ensureFileChannelExists() throws IOException {
        if (this.fileChannel == null) {
            Path filePath = Paths.get(this.filename, new String[0]);
            this.fileChannel = FileChannel.open(filePath, StandardOpenOption.READ);
            if (this.isCompressed()) {
                this.fileChannel = new GZIPFileChannel(this.fileChannel);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.close();
            this.fileChannel = null;
        }
    }

    public FileChannel takeRandomAccessFileOwnership() throws IOException {
        this.ensureFileChannelExists();
        FileChannel takenFileChannel = this.fileChannel;
        this.fileChannel = null;
        return takenFileChannel;
    }

    public boolean metadataMatches(FileInfo fileInfo) {
        return fileInfo.getSize() == this.getSize() && fileInfo.getCreated() == this.getCreated() && fileInfo.getLastModified() == this.getLastModified();
    }

    public boolean metadataMatches(BasicFileAttributes attr) {
        return attr.size() == this.getSize() && attr.creationTime().toMillis() == this.getCreated() && attr.lastModifiedTime().toMillis() == this.getLastModified();
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public long getCreated() {
        return this.created;
    }

    @Generated
    public long getLastModified() {
        return this.lastModified;
    }
}

