/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.configurator;

import com.appdynamics.analytics.agent.input.tail.TailLogInputConfiguration;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.syslog.SyslogInputConfiguration;
import com.appdynamics.analytics.agent.source.syslog.SyslogSourceConfiguration;
import com.appdynamics.analytics.agent.source.tail.TailLogSourceConfiguration;
import com.appdynamics.analytics.log.shared.agent.configurator.PipelineConfigurationConverter;
import com.appdynamics.analytics.log.shared.dto.FileConfigurationDTO;
import com.appdynamics.analytics.log.shared.dto.LogCollectionType;
import com.appdynamics.analytics.log.shared.dto.LogSourceConfigurationDTO;
import com.appdynamics.analytics.log.shared.dto.SyslogConfigurationDTO;
import com.appdynamics.analytics.log.shared.dynamic.SyslogConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.common.io.file.FilePathConfiguration;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogSourceConfigurationConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogSourceConfigurationConverter.class);
    public static final String WINDOWS_DIRECTORY_SPLIT_CHAR = "\\";
    public static final String DIRECTORY_SPLIT_CHAR = "/";
    public static final String WILDCARD_CHAR = "*";

    public static LogSourceConfiguration getLogSourceConfigurationFromDTO(LogSourceConfigurationDTO logSourceConfigurationDTO) {
        return switch (logSourceConfigurationDTO.getCollectionType()) {
            case LogCollectionType.FILE -> LogSourceConfigurationConverter.getTailLogSourceConfigurationFromDTO(logSourceConfigurationDTO);
            case LogCollectionType.NETWORK -> LogSourceConfigurationConverter.getSyslogSourceConfigurationFromDTO(logSourceConfigurationDTO);
            default -> throw new IllegalStateException(String.format("Unrecognized log source type field [%s] for log source [%s]", logSourceConfigurationDTO.getCollectionType(), logSourceConfigurationDTO.getSourceName()));
        };
    }

    private static TailLogSourceConfiguration getTailLogSourceConfigurationFromDTO(LogSourceConfigurationDTO logSourceConfigurationDTO) {
        FileConfigurationDTO fileConfigurationDTO = logSourceConfigurationDTO.getFileConfigurationDTO();
        TailLogSourceConfiguration tailLogSourceConfiguration = new TailLogSourceConfiguration();
        FilePathConfiguration pathConfiguration = LogSourceConfigurationConverter.getFilePathConfiguration(fileConfigurationDTO);
        tailLogSourceConfiguration.setSourcePath(pathConfiguration);
        TailLogInputConfiguration tailLogInputConfiguration = new TailLogInputConfiguration();
        tailLogInputConfiguration.setStartAtEnd(fileConfigurationDTO.isStartAtEnd());
        tailLogInputConfiguration.setPathExtractedFieldsGrok(fileConfigurationDTO.getPathExtractedFieldsGrok());
        PipelineConfiguration pipelineConfiguration = PipelineConfigurationConverter.getPipelineConfigurationFromDTO((LogSourceConfigurationDTO)logSourceConfigurationDTO);
        tailLogInputConfiguration.setPipelineConfiguration(pipelineConfiguration);
        tailLogSourceConfiguration.setTailLogInputConfiguration(tailLogInputConfiguration);
        tailLogSourceConfiguration.setMaximumInputPoolSize(logSourceConfigurationDTO.getNumThreads());
        tailLogSourceConfiguration.setStopIdleInputsTimeout(new TimeUnitConfiguration((long)logSourceConfigurationDTO.getWaitTime(), TimeUnit.SECONDS));
        tailLogSourceConfiguration.setCollectCompressed(logSourceConfigurationDTO.isCollectCompressed());
        LogSourceConfigurationConverter.setCommonConfigurationFromDTO(tailLogSourceConfiguration, logSourceConfigurationDTO);
        return tailLogSourceConfiguration;
    }

    private static SyslogSourceConfiguration getSyslogSourceConfigurationFromDTO(LogSourceConfigurationDTO logSourceConfigurationDTO) {
        SyslogConfigurationDTO syslogConfigurationDTO = logSourceConfigurationDTO.getSyslogConfigurationDTO();
        SyslogConfiguration syslogConfiguration = LogSourceConfigurationConverter.getSyslogConfiguration(syslogConfigurationDTO);
        syslogConfiguration.setNumThreads(logSourceConfigurationDTO.getNumThreads());
        SyslogSourceConfiguration syslogSourceConfiguration = new SyslogSourceConfiguration();
        SyslogInputConfiguration syslogInputConfiguration = new SyslogInputConfiguration();
        PipelineConfiguration pipelineConfiguration = PipelineConfigurationConverter.getPipelineConfigurationFromDTO((LogSourceConfigurationDTO)logSourceConfigurationDTO);
        syslogInputConfiguration.setPipelineConfiguration(pipelineConfiguration);
        syslogInputConfiguration.setSyslogConfiguration(syslogConfiguration);
        syslogSourceConfiguration.setSyslogInputConfiguration(syslogInputConfiguration);
        LogSourceConfigurationConverter.setCommonConfigurationFromDTO(syslogSourceConfiguration, logSourceConfigurationDTO);
        return syslogSourceConfiguration;
    }

    @VisibleForTesting
    public static FilePathConfiguration getFilePathConfiguration(FileConfigurationDTO fileConfigurationDTO) {
        int endIndex;
        String path;
        FilePathConfiguration pathConfiguration = new FilePathConfiguration();
        String prefixPath = path = fileConfigurationDTO.getPath();
        int indexOfWildcard = path.indexOf(WILDCARD_CHAR);
        if (indexOfWildcard >= 0) {
            prefixPath = prefixPath.substring(0, indexOfWildcard);
        }
        if ((endIndex = prefixPath.lastIndexOf(DIRECTORY_SPLIT_CHAR)) == -1) {
            endIndex = prefixPath.lastIndexOf(WINDOWS_DIRECTORY_SPLIT_CHAR);
        }
        if (endIndex == -1) {
            throw new IllegalArgumentException(String.format("Incorrect path '[%s]' passed.", path));
        }
        String nameGlob = path.substring(endIndex + 1);
        pathConfiguration.setPath(path.substring(0, endIndex));
        pathConfiguration.setNameGlob(nameGlob);
        pathConfiguration.setBlacklistGlob(fileConfigurationDTO.getBlacklistGlob());
        return pathConfiguration;
    }

    @VisibleForTesting
    public static SyslogConfiguration getSyslogConfiguration(SyslogConfigurationDTO syslogConfigurationDTO) {
        SyslogConfiguration syslogConfiguration = new SyslogConfiguration();
        syslogConfiguration.setPort(syslogConfigurationDTO.getPort());
        if (syslogConfigurationDTO.getProtocol() != SyslogConfigurationDTO.Protocol.TCP) {
            throw new IllegalStateException(String.format("Unrecognized Protocol field [%s].", syslogConfigurationDTO.getProtocol()));
        }
        syslogConfiguration.setProtocol(SyslogConfiguration.Protocol.TCP);
        syslogConfiguration.setCharset(syslogConfigurationDTO.getCharset());
        return syslogConfiguration;
    }

    private static void setCommonConfigurationFromDTO(LogSourceConfiguration logSourceConfiguration, LogSourceConfigurationDTO logSourceConfigurationDTO) {
        String sourceType = logSourceConfigurationDTO.getSourceType();
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)sourceType), (String)"Found blank sourceType for log source [%s]", (Object)logSourceConfigurationDTO.getSourceName());
        logSourceConfiguration.setSourceType(logSourceConfigurationDTO.getSourceType());
        logSourceConfiguration.setId(logSourceConfigurationDTO.getLogSourceId());
        String name = logSourceConfigurationDTO.getSourceName();
        logSourceConfiguration.setName(name.toString());
        logSourceConfiguration.setEnabled(logSourceConfigurationDTO.isEnabled());
        logSourceConfiguration.setCorrectDuplicateTimestamp(logSourceConfigurationDTO.getTimestampConfiguration().isCorrectDuplicateTimestamps());
        logSourceConfiguration.setDisableImportedSourceId(logSourceConfigurationDTO.isDisableImportedSourceId());
        if (logSourceConfigurationDTO.getImportedFromSourceId() != null) {
            logSourceConfiguration.setImportedFromSourceId(logSourceConfigurationDTO.getImportedFromSourceId());
        }
    }

    @Generated
    private LogSourceConfigurationConverter() {
    }
}

