/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.base;

import com.appdynamics.analytics.agent.source.LogComponentFactory;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.item.SimpleItem;
import com.appdynamics.common.util.lifecycle.LifecycleAware;
import com.appdynamics.common.util.lifecycle.MutableRunningState;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogBase
extends SimpleItem<Object>
implements LifecycleAware,
HealthCheckable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogBase.class);
    protected static final long DEFAULT_STOP_TIMEOUT_MILLIS = 30000L;
    protected final ExecutorService executorService;
    protected final LogComponentFactory factory;
    protected final MutableRunningState runningState;

    protected LogBase(String name, LogComponentFactory factory, ExecutorService executorService) {
        super.setId((Object)name);
        this.factory = factory;
        this.executorService = executorService;
        this.runningState = factory.createRunningState(false);
    }

    public boolean isRunning() {
        return this.getRunningState().get();
    }

    public String getName() {
        return (String)super.getId();
    }

    public synchronized void start() {
        log.info("Starting [{}]", (Object)this.getName());
        this.runningState.set(true);
    }

    public synchronized void stop() {
        log.info("Stopping [{}]", (Object)this.getName());
        this.runningState.set(false);
    }

    public void sleepWhileRunning(long milliseconds) {
        try {
            this.runningState.sleepWhileRunning(milliseconds);
        }
        catch (InterruptedException e) {
            log.debug("Thread interrupted while sleeping.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Generated
    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Generated
    protected LogComponentFactory getFactory() {
        return this.factory;
    }

    @Generated
    protected MutableRunningState getRunningState() {
        return this.runningState;
    }
}

