/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.validator;

import com.appdynamics.analytics.log.shared.dto.TypeConversionConfiguration;
import com.appdynamics.common.util.type.ValueType;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={ValidTypeConversionConfigurationValidator.class})
public @interface ValidTypeConversionConfiguration {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class ValidTypeConversionConfigurationValidator
    implements ConstraintValidator<ValidTypeConversionConfiguration, TypeConversionConfiguration> {
        public void initialize(ValidTypeConversionConfiguration constraintAnnotation) {
        }

        public boolean isValid(TypeConversionConfiguration config, ConstraintValidatorContext context) {
            if (config.getType() == ValueType.TIMESTAMP && (config.getFormat() == null || config.getFormat().isEmpty())) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(String.format("If type is equal to [%s] then the format field must be specified", ValueType.TIMESTAMP)).addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

