/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.validator;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={RegexValidator.class})
public @interface ValidRegex {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class RegexValidator
    implements ConstraintValidator<ValidRegex, String> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(RegexValidator.class);

        public void initialize(ValidRegex constraintAnnotation) {
        }

        public boolean isValid(String regex, ConstraintValidatorContext context) {
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate("Invalid Regex").addConstraintViolation();
                log.info("Invalid Regex ", (Throwable)e);
                return false;
            }
            return true;
        }
    }
}

