/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.validator;

import com.appdynamics.analytics.pipeline.xform.Constants;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;
import java.util.List;

public abstract class NoRestrictedFieldsValidator<A extends Annotation, T>
implements ConstraintValidator<A, T> {
    public boolean isValid(T field, ConstraintValidatorContext context) {
        if (field == null) {
            return true;
        }
        try {
            List<String> fieldNames = this.getFieldNames(field);
            for (String fieldName : fieldNames) {
                if (!Constants.RESERVED_FIELDS.contains(fieldName.toLowerCase())) continue;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(String.format("The configuration cannot contain [%s] which is a reserved keyword.", fieldName)).addConstraintViolation();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(e.getMessage()).addConstraintViolation();
            return false;
        }
    }

    protected abstract List<String> getFieldNames(T var1);
}

