/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.validator;

import com.appdynamics.common.util.configuration.ConfigurationException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public abstract class NoDuplicateFieldsValidator<A extends Annotation, T>
implements ConstraintValidator<A, T> {
    public boolean isValid(T field, ConstraintValidatorContext context) {
        try {
            if (field == null) {
                return true;
            }
            try {
                List<String> fieldNames = this.getFieldNames(field);
                List<String> duplicateFields = this.getDuplicateFields(fieldNames);
                if (!duplicateFields.isEmpty()) {
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate(String.format("Attempt has been made to add duplicate keys %s", duplicateFields)).addConstraintViolation();
                    return false;
                }
                return true;
            }
            catch (ConfigurationException e) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(e.getMessage()).addConstraintViolation();
                return false;
            }
        }
        catch (Exception e) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(e.getMessage()).addConstraintViolation();
            return false;
        }
    }

    protected abstract List<String> getFieldNames(T var1);

    private List<String> getDuplicateFields(List<String> fieldNames) {
        ArrayList<String> duplicateFields = new ArrayList<String>();
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String fieldName : fieldNames) {
            if (set.add(fieldName)) continue;
            duplicateFields.add(fieldName);
        }
        return duplicateFields;
    }
}

