/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.preview;

import com.appdynamics.analytics.log.shared.agent.configurator.PipelineConfigurationConverter;
import com.appdynamics.analytics.log.shared.dto.LogSourceConfigurationDTO;
import com.appdynamics.analytics.log.shared.preview.PreviewLogPipelineStageFactories;
import com.appdynamics.analytics.pipeline.api.PipelineStage;
import com.appdynamics.analytics.pipeline.api.PipelineStageFactory;
import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.framework.Pipeline;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineStageConfiguration;
import com.appdynamics.analytics.pipeline.framework.Pipelines;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.common.util.datetime.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import lombok.Generated;

public class PreviewLogLinesHelper {
    private static final Ticker DEFAULT_TICKER = new Ticker();
    private static final long MAX_SINGLE_LINE_PREVIEW_MILLIS = 250L;
    private static final PipelineStageFactory NOP_PIPELINE_STAGE_FACTORY = new NopPipelineStageFactory();
    private static final String COLLECTION_URI = "collection";
    private static final PipelineStageFactory COLLECTION_PIPELINE_STAGE_FACTORY = new CollectionPipelineStageFactory();
    private static Map<String, PipelineStageFactory> PIPELINE_STAGE_FACTORIES_MAP = ImmutableMap.builder().putAll(PreviewLogPipelineStageFactories.getPreviewPipelineStageFactoryMap()).put((Object)"xform:json:map2Json", (Object)NOP_PIPELINE_STAGE_FACTORY).put((Object)"tap", (Object)NOP_PIPELINE_STAGE_FACTORY).put((Object)"collection", (Object)COLLECTION_PIPELINE_STAGE_FACTORY).build();

    private PreviewLogLinesHelper() {
    }

    public static List<Map<String, Object>> preview(LogSourceConfigurationDTO logSourceConfigurationDTO, List<String> messages) throws TimeoutException {
        return PreviewLogLinesHelper.preview(logSourceConfigurationDTO, messages, 250L);
    }

    public static List<Map<String, Object>> preview(LogSourceConfigurationDTO logSourceConfigurationDTO, List<String> messages, long previewLineTimeoutMillis) throws TimeoutException {
        return PreviewLogLinesHelper.preview(logSourceConfigurationDTO, messages, previewLineTimeoutMillis, DEFAULT_TICKER);
    }

    public static List<Map<String, Object>> preview(LogSourceConfigurationDTO logSourceConfigurationDTO, List<String> messages, long previewLineTimeoutMillis, Ticker ticker) throws TimeoutException {
        PipelineConfiguration pipelineConfiguration = PipelineConfigurationConverter.getPipelineConfigurationFromDTO(logSourceConfigurationDTO);
        PipelineStageConfiguration collectionPipelineStageConfiguration = new PipelineStageConfiguration();
        collectionPipelineStageConfiguration.setUri(COLLECTION_URI);
        pipelineConfiguration.setStages((List)ImmutableList.builder().addAll((Iterable)pipelineConfiguration.getStages()).add((Object)collectionPipelineStageConfiguration).build());
        pipelineConfiguration.setEnabled(true);
        Pipeline pipeline = Pipelines.createPipeline((PipelineConfiguration)pipelineConfiguration, PIPELINE_STAGE_FACTORIES_MAP);
        pipeline.start();
        for (String message : messages) {
            long start = ticker.currentTimeMillis();
            pipeline.call((Object)message);
            long end = ticker.currentTimeMillis();
            if (end - start < previewLineTimeoutMillis) continue;
            throw new TimeoutException("Preview took too long.  This may be because the server is busy or the configuration rules perform too slow on the sample log file.");
        }
        pipeline.call(null);
        pipeline.stop();
        List pipelineStages = pipeline.getPipelineStages();
        CollectionPipelineStage collectionPipelineStage = (CollectionPipelineStage)((Object)pipelineStages.get(pipelineStages.size() - 1));
        return collectionPipelineStage.getCollectedMessages();
    }

    public static class CollectionPipelineStage
    extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
        private List<Map<String, Object>> collectedMessages = new LinkedList<Map<String, Object>>();

        public CollectionPipelineStage(PipelineStageParameters<Map<String, Object>> parameters) {
            super(parameters);
        }

        public void process(Map<String, Object> input) {
            this.collectedMessages.add(input);
            this.invokeNext(input);
        }

        public void start() {
        }

        public void stop() {
        }

        @Generated
        public List<Map<String, Object>> getCollectedMessages() {
            return this.collectedMessages;
        }
    }

    private static class NopPipelineStageFactory
    implements PipelineStageFactory<Map<String, Object>, Map<String, Object>> {
        private NopPipelineStageFactory() {
        }

        public PipelineStage<Map<String, Object>, Map<String, Object>> create(PipelineStageParameters<Map<String, Object>> parameters) {
            return new NopPipelineStage(parameters);
        }
    }

    private static class CollectionPipelineStageFactory
    implements PipelineStageFactory<Map<String, Object>, Map<String, Object>> {
        private CollectionPipelineStageFactory() {
        }

        public PipelineStage<Map<String, Object>, Map<String, Object>> create(PipelineStageParameters<Map<String, Object>> parameters) {
            return new CollectionPipelineStage(parameters);
        }
    }

    public static class NopPipelineStage
    extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
        public NopPipelineStage(PipelineStageParameters<Map<String, Object>> parameters) {
            super(parameters);
        }

        public void process(Map<String, Object> input) {
            this.invokeNext(input);
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

