/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.dynamic;

import com.appdynamics.analytics.log.shared.dynamic.DslConfigurationV2;
import com.appdynamics.analytics.log.shared.dynamic.FileConfiguration;
import com.appdynamics.analytics.log.shared.dynamic.JobConfiguration;
import com.appdynamics.analytics.log.shared.dynamic.SourceConfiguration;
import com.appdynamics.analytics.log.shared.dynamic.SyslogConfiguration;
import com.appdynamics.analytics.pipeline.xform.field.FieldMaskingStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.field.FieldRemovalStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.field.FieldRenameStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.field.FieldTransformationStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.field.FieldTypeConversionStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.grok.GrokStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.guid.RequestGuidStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.keyvalue.KeyValueStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.regex.RegexStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.text.MatchType;
import com.appdynamics.analytics.pipeline.xform.time.DateTimeExtractorConfiguration;
import com.appdynamics.analytics.pipeline.xform.time.DuplicateTimestampCorrectionConfiguration;
import com.appdynamics.analytics.pipeline.xform.time.TimestampFilterConfiguration;
import com.appdynamics.common.util.configuration.Reader;
import com.google.common.reflect.TypeToken;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TemplateConfigurationV2
implements JobConfiguration {
    @Min(value=2L)
    @Min(value=2L) int version = 2;
    boolean enabled;
    @Valid
    SourceConfiguration source;
    @Size(max=1)
    @Size(max=1) List<Pair<MatchType, String>> multiline;
    List<Pair<String, String>> fields;
    GrokStageConfiguration grok;
    RegexStageConfiguration regex;
    KeyValueStageConfiguration keyValue;
    RequestGuidStageConfiguration requestGuid;
    DateTimeExtractorConfiguration eventTimestamp;
    TimestampFilterConfiguration timestampFilter;
    FieldTransformationStageConfiguration transform;
    FieldRenameStageConfiguration rename;
    FieldTypeConversionStageConfiguration typeConversion;
    FieldRemovalStageConfiguration removeFields;
    FieldMaskingStageConfiguration fieldMasking;
    DuplicateTimestampCorrectionConfiguration duplicateTimestampCorrection;

    public static TemplateConfigurationV2 from(DslConfigurationV2 dsl) {
        TemplateConfigurationV2 tc = new TemplateConfigurationV2();
        tc.setEnabled(dsl.isEnabled());
        TemplateConfigurationV2.extractSource(dsl, tc);
        if (dsl.getMultiline() != null) {
            List<Pair<MatchType, String>> multilinePairs = TemplateConfigurationV2.from(dsl.getMultiline());
            tc.setMultiline(multilinePairs);
        }
        if (dsl.getFields() != null) {
            List<Pair<String, String>> fields = TemplateConfigurationV2.from(dsl.getFields());
            tc.setFields(fields);
        }
        tc.setGrok(dsl.getGrok());
        tc.setRegex(dsl.getRegex());
        tc.setKeyValue(dsl.getKeyValue());
        tc.setRequestGuid(dsl.getRequestGuid());
        tc.setEventTimestamp(dsl.getEventTimestamp());
        tc.setDuplicateTimestampCorrection(dsl.getDuplicateTimestampCorrection());
        tc.setTimestampFilter(dsl.getTimestampFilter());
        tc.setTransform(dsl.getTransform());
        tc.setRename(dsl.getRename());
        tc.setTypeConversion(dsl.getTypeConversion());
        tc.setRemoveFields(dsl.getRemoveFields());
        tc.setFieldMasking(dsl.getFieldMasking());
        return tc;
    }

    private static void extractSource(DslConfigurationV2 from, TemplateConfigurationV2 to) {
        DslConfigurationV2.LazyLogSourceConfiguration lazySource = from.getSource();
        SourceConfiguration source = null;
        switch ((String)lazySource.get("type")) {
            case "file": {
                source = (SourceConfiguration)Reader.readFrom((TypeToken)new TypeToken<FileConfiguration>(){}, (Object)lazySource);
                break;
            }
            case "syslog": {
                source = (SourceConfiguration)Reader.readFrom((TypeToken)new TypeToken<SyslogConfiguration>(){}, (Object)lazySource);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type [" + String.valueOf(lazySource.get("type")) + "]");
            }
        }
        to.setSource(source);
    }

    public static <K, V> List<Pair<K, V>> from(Map<K, V> map) {
        LinkedList<Pair<K, V>> pairs = new LinkedList<Pair<K, V>>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = TemplateConfigurationV2.from((Map)value);
            }
            pairs.add((Pair<K, V>)new ImmutablePair(entry.getKey(), value));
        }
        return pairs;
    }

    @Generated
    public TemplateConfigurationV2() {
    }

    @Override
    @Generated
    public int getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public SourceConfiguration getSource() {
        return this.source;
    }

    @Generated
    public List<Pair<MatchType, String>> getMultiline() {
        return this.multiline;
    }

    @Generated
    public List<Pair<String, String>> getFields() {
        return this.fields;
    }

    @Generated
    public GrokStageConfiguration getGrok() {
        return this.grok;
    }

    @Generated
    public RegexStageConfiguration getRegex() {
        return this.regex;
    }

    @Generated
    public KeyValueStageConfiguration getKeyValue() {
        return this.keyValue;
    }

    @Generated
    public RequestGuidStageConfiguration getRequestGuid() {
        return this.requestGuid;
    }

    @Generated
    public DateTimeExtractorConfiguration getEventTimestamp() {
        return this.eventTimestamp;
    }

    @Generated
    public TimestampFilterConfiguration getTimestampFilter() {
        return this.timestampFilter;
    }

    @Generated
    public FieldTransformationStageConfiguration getTransform() {
        return this.transform;
    }

    @Generated
    public FieldRenameStageConfiguration getRename() {
        return this.rename;
    }

    @Generated
    public FieldTypeConversionStageConfiguration getTypeConversion() {
        return this.typeConversion;
    }

    @Generated
    public FieldRemovalStageConfiguration getRemoveFields() {
        return this.removeFields;
    }

    @Generated
    public FieldMaskingStageConfiguration getFieldMasking() {
        return this.fieldMasking;
    }

    @Generated
    public DuplicateTimestampCorrectionConfiguration getDuplicateTimestampCorrection() {
        return this.duplicateTimestampCorrection;
    }

    @Generated
    public void setVersion(int version) {
        this.version = version;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSource(SourceConfiguration source) {
        this.source = source;
    }

    @Generated
    public void setMultiline(List<Pair<MatchType, String>> multiline) {
        this.multiline = multiline;
    }

    @Generated
    public void setFields(List<Pair<String, String>> fields) {
        this.fields = fields;
    }

    @Generated
    public void setGrok(GrokStageConfiguration grok) {
        this.grok = grok;
    }

    @Generated
    public void setRegex(RegexStageConfiguration regex) {
        this.regex = regex;
    }

    @Generated
    public void setKeyValue(KeyValueStageConfiguration keyValue) {
        this.keyValue = keyValue;
    }

    @Generated
    public void setRequestGuid(RequestGuidStageConfiguration requestGuid) {
        this.requestGuid = requestGuid;
    }

    @Generated
    public void setEventTimestamp(DateTimeExtractorConfiguration eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    @Generated
    public void setTimestampFilter(TimestampFilterConfiguration timestampFilter) {
        this.timestampFilter = timestampFilter;
    }

    @Generated
    public void setTransform(FieldTransformationStageConfiguration transform) {
        this.transform = transform;
    }

    @Generated
    public void setRename(FieldRenameStageConfiguration rename) {
        this.rename = rename;
    }

    @Generated
    public void setTypeConversion(FieldTypeConversionStageConfiguration typeConversion) {
        this.typeConversion = typeConversion;
    }

    @Generated
    public void setRemoveFields(FieldRemovalStageConfiguration removeFields) {
        this.removeFields = removeFields;
    }

    @Generated
    public void setFieldMasking(FieldMaskingStageConfiguration fieldMasking) {
        this.fieldMasking = fieldMasking;
    }

    @Generated
    public void setDuplicateTimestampCorrection(DuplicateTimestampCorrectionConfiguration duplicateTimestampCorrection) {
        this.duplicateTimestampCorrection = duplicateTimestampCorrection;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateConfigurationV2)) {
            return false;
        }
        TemplateConfigurationV2 other = (TemplateConfigurationV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        SourceConfiguration this$source = this.getSource();
        SourceConfiguration other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<Pair<MatchType, String>> this$multiline = this.getMultiline();
        List<Pair<MatchType, String>> other$multiline = other.getMultiline();
        if (this$multiline == null ? other$multiline != null : !((Object)this$multiline).equals(other$multiline)) {
            return false;
        }
        List<Pair<String, String>> this$fields = this.getFields();
        List<Pair<String, String>> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        GrokStageConfiguration this$grok = this.getGrok();
        GrokStageConfiguration other$grok = other.getGrok();
        if (this$grok == null ? other$grok != null : !this$grok.equals(other$grok)) {
            return false;
        }
        RegexStageConfiguration this$regex = this.getRegex();
        RegexStageConfiguration other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        KeyValueStageConfiguration this$keyValue = this.getKeyValue();
        KeyValueStageConfiguration other$keyValue = other.getKeyValue();
        if (this$keyValue == null ? other$keyValue != null : !this$keyValue.equals(other$keyValue)) {
            return false;
        }
        RequestGuidStageConfiguration this$requestGuid = this.getRequestGuid();
        RequestGuidStageConfiguration other$requestGuid = other.getRequestGuid();
        if (this$requestGuid == null ? other$requestGuid != null : !this$requestGuid.equals(other$requestGuid)) {
            return false;
        }
        DateTimeExtractorConfiguration this$eventTimestamp = this.getEventTimestamp();
        DateTimeExtractorConfiguration other$eventTimestamp = other.getEventTimestamp();
        if (this$eventTimestamp == null ? other$eventTimestamp != null : !this$eventTimestamp.equals(other$eventTimestamp)) {
            return false;
        }
        TimestampFilterConfiguration this$timestampFilter = this.getTimestampFilter();
        TimestampFilterConfiguration other$timestampFilter = other.getTimestampFilter();
        if (this$timestampFilter == null ? other$timestampFilter != null : !this$timestampFilter.equals(other$timestampFilter)) {
            return false;
        }
        FieldTransformationStageConfiguration this$transform = this.getTransform();
        FieldTransformationStageConfiguration other$transform = other.getTransform();
        if (this$transform == null ? other$transform != null : !this$transform.equals(other$transform)) {
            return false;
        }
        FieldRenameStageConfiguration this$rename = this.getRename();
        FieldRenameStageConfiguration other$rename = other.getRename();
        if (this$rename == null ? other$rename != null : !this$rename.equals(other$rename)) {
            return false;
        }
        FieldTypeConversionStageConfiguration this$typeConversion = this.getTypeConversion();
        FieldTypeConversionStageConfiguration other$typeConversion = other.getTypeConversion();
        if (this$typeConversion == null ? other$typeConversion != null : !this$typeConversion.equals(other$typeConversion)) {
            return false;
        }
        FieldRemovalStageConfiguration this$removeFields = this.getRemoveFields();
        FieldRemovalStageConfiguration other$removeFields = other.getRemoveFields();
        if (this$removeFields == null ? other$removeFields != null : !this$removeFields.equals(other$removeFields)) {
            return false;
        }
        FieldMaskingStageConfiguration this$fieldMasking = this.getFieldMasking();
        FieldMaskingStageConfiguration other$fieldMasking = other.getFieldMasking();
        if (this$fieldMasking == null ? other$fieldMasking != null : !this$fieldMasking.equals(other$fieldMasking)) {
            return false;
        }
        DuplicateTimestampCorrectionConfiguration this$duplicateTimestampCorrection = this.getDuplicateTimestampCorrection();
        DuplicateTimestampCorrectionConfiguration other$duplicateTimestampCorrection = other.getDuplicateTimestampCorrection();
        return !(this$duplicateTimestampCorrection == null ? other$duplicateTimestampCorrection != null : !this$duplicateTimestampCorrection.equals(other$duplicateTimestampCorrection));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TemplateConfigurationV2;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        SourceConfiguration $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<Pair<MatchType, String>> $multiline = this.getMultiline();
        result = result * 59 + ($multiline == null ? 43 : ((Object)$multiline).hashCode());
        List<Pair<String, String>> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        GrokStageConfiguration $grok = this.getGrok();
        result = result * 59 + ($grok == null ? 43 : $grok.hashCode());
        RegexStageConfiguration $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        KeyValueStageConfiguration $keyValue = this.getKeyValue();
        result = result * 59 + ($keyValue == null ? 43 : $keyValue.hashCode());
        RequestGuidStageConfiguration $requestGuid = this.getRequestGuid();
        result = result * 59 + ($requestGuid == null ? 43 : $requestGuid.hashCode());
        DateTimeExtractorConfiguration $eventTimestamp = this.getEventTimestamp();
        result = result * 59 + ($eventTimestamp == null ? 43 : $eventTimestamp.hashCode());
        TimestampFilterConfiguration $timestampFilter = this.getTimestampFilter();
        result = result * 59 + ($timestampFilter == null ? 43 : $timestampFilter.hashCode());
        FieldTransformationStageConfiguration $transform = this.getTransform();
        result = result * 59 + ($transform == null ? 43 : $transform.hashCode());
        FieldRenameStageConfiguration $rename = this.getRename();
        result = result * 59 + ($rename == null ? 43 : $rename.hashCode());
        FieldTypeConversionStageConfiguration $typeConversion = this.getTypeConversion();
        result = result * 59 + ($typeConversion == null ? 43 : $typeConversion.hashCode());
        FieldRemovalStageConfiguration $removeFields = this.getRemoveFields();
        result = result * 59 + ($removeFields == null ? 43 : $removeFields.hashCode());
        FieldMaskingStageConfiguration $fieldMasking = this.getFieldMasking();
        result = result * 59 + ($fieldMasking == null ? 43 : $fieldMasking.hashCode());
        DuplicateTimestampCorrectionConfiguration $duplicateTimestampCorrection = this.getDuplicateTimestampCorrection();
        result = result * 59 + ($duplicateTimestampCorrection == null ? 43 : $duplicateTimestampCorrection.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TemplateConfigurationV2(version=" + this.getVersion() + ", enabled=" + this.isEnabled() + ", source=" + String.valueOf(this.getSource()) + ", multiline=" + String.valueOf(this.getMultiline()) + ", fields=" + String.valueOf(this.getFields()) + ", grok=" + String.valueOf(this.getGrok()) + ", regex=" + String.valueOf(this.getRegex()) + ", keyValue=" + String.valueOf(this.getKeyValue()) + ", requestGuid=" + String.valueOf(this.getRequestGuid()) + ", eventTimestamp=" + String.valueOf(this.getEventTimestamp()) + ", timestampFilter=" + String.valueOf(this.getTimestampFilter()) + ", transform=" + String.valueOf(this.getTransform()) + ", rename=" + String.valueOf(this.getRename()) + ", typeConversion=" + String.valueOf(this.getTypeConversion()) + ", removeFields=" + String.valueOf(this.getRemoveFields()) + ", fieldMasking=" + String.valueOf(this.getFieldMasking()) + ", duplicateTimestampCorrection=" + String.valueOf(this.getDuplicateTimestampCorrection()) + ")";
    }
}

