/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.dynamic;

import com.appdynamics.analytics.log.shared.dynamic.SourceConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SyslogConfiguration
implements SourceConfiguration {
    public static final int DEFAULT_NUM_THREADS = 1;
    @Range(min=0L, max=65535L)
    @Range(min=0L, max=65535L) int port = 514;
    @NotNull
    Protocol protocol;
    @Min(value=1L)
    @Min(value=1L) int numThreads = 1;
    @NotNull
    String charset = StandardCharsets.UTF_8.name();

    public boolean isTypeSyslog() {
        return true;
    }

    public String getServerId() {
        return String.format("syslog-%s-%d", this.protocol.toString().toLowerCase(), this.port);
    }

    @Generated
    public SyslogConfiguration() {
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Generated
    public int getNumThreads() {
        return this.numThreads;
    }

    @Generated
    public String getCharset() {
        return this.charset;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Generated
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyslogConfiguration)) {
            return false;
        }
        SyslogConfiguration other = (SyslogConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getNumThreads() != other.getNumThreads()) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SyslogConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getNumThreads();
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SyslogConfiguration(port=" + this.getPort() + ", protocol=" + String.valueOf((Object)this.getProtocol()) + ", numThreads=" + this.getNumThreads() + ", charset=" + this.getCharset() + ")";
    }

    public static enum Protocol {
        TCP;

    }
}

