/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.dto;

import com.appdynamics.analytics.grok.GrokLoaderFactory;
import com.appdynamics.analytics.log.shared.dto.FieldConfigType;
import com.appdynamics.analytics.log.shared.dto.FieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.FieldInfo;
import com.appdynamics.common.util.grok.Grok;
import com.appdynamics.common.util.regex.RegexPattern;
import com.appdynamics.common.util.type.ValueType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.ImmutableList;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GrokFieldExtractionConfiguration
extends FieldExtractionConfiguration {
    private String source = "message";
    @NotEmpty(message="The grok pattern is missing")
    @Valid
    private @NotEmpty(message="The grok pattern is missing") @Valid String pattern;

    public GrokFieldExtractionConfiguration() {
        this.fieldConfigType = FieldConfigType.GROK;
    }

    public GrokFieldExtractionConfiguration(String pattern) {
        this.pattern = pattern;
        this.fieldConfigType = FieldConfigType.GROK;
    }

    public GrokFieldExtractionConfiguration(String source, String pattern) {
        this.source = source;
        this.pattern = pattern;
        this.fieldConfigType = FieldConfigType.GROK;
    }

    @Override
    public List<String> getFieldNames() {
        Grok GROK = new GrokLoaderFactory().makeGrok();
        RegexPattern regexPattern = GROK.compile(this.pattern);
        if (regexPattern.getAliases() != null) {
            return ImmutableList.copyOf((Object[])regexPattern.getAliases());
        }
        return ImmutableList.of();
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        Grok GROK = new GrokLoaderFactory().makeGrok();
        RegexPattern regexPattern = GROK.compile(this.pattern);
        if (regexPattern.getAliases() != null) {
            String[] aliases = regexPattern.getAliases();
            ValueType[] valueTypes = regexPattern.getValueTypes();
            for (int i = 0; i < aliases.length; ++i) {
                fields.add(new FieldInfo(aliases[i], valueTypes[i]));
            }
        }
        return ImmutableList.copyOf(fields);
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Generated
    public String toString() {
        return "GrokFieldExtractionConfiguration(source=" + this.getSource() + ", pattern=" + this.getPattern() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrokFieldExtractionConfiguration)) {
            return false;
        }
        GrokFieldExtractionConfiguration other = (GrokFieldExtractionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GrokFieldExtractionConfiguration;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        return result;
    }
}

