/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.dto;

import com.appdynamics.analytics.log.shared.dto.LogSourceConfigurationDTO;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AgentSourceConfiguration {
    boolean disableAllSources;
    boolean disableAllLocalSources;
    long configSyncIntervalMillis;
    long configSyncIntervalMinMillis;
    long configSyncIntervalMaxMillis;
    double healthErrorThreshold;
    long lscConfigHash;
    @Nullable
    List<LogSourceConfigurationDTO> logSourceConfigurationDTOs;

    public AgentSourceConfiguration() {
    }

    public AgentSourceConfiguration(boolean disableAllSources, boolean disableAllLocalSources, long configSyncIntervalMillis, long configSyncIntervalMinMillis, long configSyncIntervalMaxMillis, double healthErrorThreshold, long lscConfigHash, List<LogSourceConfigurationDTO> logSourceConfigurationDTOs) {
        this.disableAllSources = disableAllSources;
        this.disableAllLocalSources = disableAllLocalSources;
        this.configSyncIntervalMillis = configSyncIntervalMillis;
        this.configSyncIntervalMinMillis = configSyncIntervalMinMillis;
        this.configSyncIntervalMaxMillis = configSyncIntervalMaxMillis;
        this.healthErrorThreshold = healthErrorThreshold;
        this.lscConfigHash = lscConfigHash;
        this.logSourceConfigurationDTOs = logSourceConfigurationDTOs;
    }

    public Map<String, LogSourceConfigurationDTO> toLogSourceConfigurationMap() {
        HashMap<String, LogSourceConfigurationDTO> map = new HashMap<String, LogSourceConfigurationDTO>();
        for (LogSourceConfigurationDTO sourceDTO : this.getLogSourceConfigurationDTOs()) {
            map.put(sourceDTO.getLogSourceId(), sourceDTO);
        }
        return map;
    }

    public Set<String> getPermanentDisabledConfigs() {
        TreeSet<String> permanentlyDisabledConfigs = new TreeSet<String>();
        if (this.logSourceConfigurationDTOs != null) {
            for (LogSourceConfigurationDTO dto : this.getLogSourceConfigurationDTOs()) {
                if (!dto.isEnabled() || !dto.isDisableImportedSourceId() || dto.getImportedFromSourceId() == null) continue;
                permanentlyDisabledConfigs.add(dto.getImportedFromSourceId());
            }
        }
        return permanentlyDisabledConfigs;
    }

    @Generated
    public boolean isDisableAllSources() {
        return this.disableAllSources;
    }

    @Generated
    public boolean isDisableAllLocalSources() {
        return this.disableAllLocalSources;
    }

    @Generated
    public long getConfigSyncIntervalMillis() {
        return this.configSyncIntervalMillis;
    }

    @Generated
    public long getConfigSyncIntervalMinMillis() {
        return this.configSyncIntervalMinMillis;
    }

    @Generated
    public long getConfigSyncIntervalMaxMillis() {
        return this.configSyncIntervalMaxMillis;
    }

    @Generated
    public double getHealthErrorThreshold() {
        return this.healthErrorThreshold;
    }

    @Generated
    public long getLscConfigHash() {
        return this.lscConfigHash;
    }

    @Nullable
    @Generated
    public List<LogSourceConfigurationDTO> getLogSourceConfigurationDTOs() {
        return this.logSourceConfigurationDTOs;
    }

    @Generated
    public void setDisableAllSources(boolean disableAllSources) {
        this.disableAllSources = disableAllSources;
    }

    @Generated
    public void setDisableAllLocalSources(boolean disableAllLocalSources) {
        this.disableAllLocalSources = disableAllLocalSources;
    }

    @Generated
    public void setConfigSyncIntervalMillis(long configSyncIntervalMillis) {
        this.configSyncIntervalMillis = configSyncIntervalMillis;
    }

    @Generated
    public void setConfigSyncIntervalMinMillis(long configSyncIntervalMinMillis) {
        this.configSyncIntervalMinMillis = configSyncIntervalMinMillis;
    }

    @Generated
    public void setConfigSyncIntervalMaxMillis(long configSyncIntervalMaxMillis) {
        this.configSyncIntervalMaxMillis = configSyncIntervalMaxMillis;
    }

    @Generated
    public void setHealthErrorThreshold(double healthErrorThreshold) {
        this.healthErrorThreshold = healthErrorThreshold;
    }

    @Generated
    public void setLscConfigHash(long lscConfigHash) {
        this.lscConfigHash = lscConfigHash;
    }

    @Generated
    public void setLogSourceConfigurationDTOs(@Nullable List<LogSourceConfigurationDTO> logSourceConfigurationDTOs) {
        this.logSourceConfigurationDTOs = logSourceConfigurationDTOs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentSourceConfiguration)) {
            return false;
        }
        AgentSourceConfiguration other = (AgentSourceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisableAllSources() != other.isDisableAllSources()) {
            return false;
        }
        if (this.isDisableAllLocalSources() != other.isDisableAllLocalSources()) {
            return false;
        }
        if (this.getConfigSyncIntervalMillis() != other.getConfigSyncIntervalMillis()) {
            return false;
        }
        if (this.getConfigSyncIntervalMinMillis() != other.getConfigSyncIntervalMinMillis()) {
            return false;
        }
        if (this.getConfigSyncIntervalMaxMillis() != other.getConfigSyncIntervalMaxMillis()) {
            return false;
        }
        if (Double.compare(this.getHealthErrorThreshold(), other.getHealthErrorThreshold()) != 0) {
            return false;
        }
        if (this.getLscConfigHash() != other.getLscConfigHash()) {
            return false;
        }
        List<LogSourceConfigurationDTO> this$logSourceConfigurationDTOs = this.getLogSourceConfigurationDTOs();
        List<LogSourceConfigurationDTO> other$logSourceConfigurationDTOs = other.getLogSourceConfigurationDTOs();
        return !(this$logSourceConfigurationDTOs == null ? other$logSourceConfigurationDTOs != null : !((Object)this$logSourceConfigurationDTOs).equals(other$logSourceConfigurationDTOs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentSourceConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisableAllSources() ? 79 : 97);
        result = result * 59 + (this.isDisableAllLocalSources() ? 79 : 97);
        long $configSyncIntervalMillis = this.getConfigSyncIntervalMillis();
        result = result * 59 + (int)($configSyncIntervalMillis >>> 32 ^ $configSyncIntervalMillis);
        long $configSyncIntervalMinMillis = this.getConfigSyncIntervalMinMillis();
        result = result * 59 + (int)($configSyncIntervalMinMillis >>> 32 ^ $configSyncIntervalMinMillis);
        long $configSyncIntervalMaxMillis = this.getConfigSyncIntervalMaxMillis();
        result = result * 59 + (int)($configSyncIntervalMaxMillis >>> 32 ^ $configSyncIntervalMaxMillis);
        long $healthErrorThreshold = Double.doubleToLongBits(this.getHealthErrorThreshold());
        result = result * 59 + (int)($healthErrorThreshold >>> 32 ^ $healthErrorThreshold);
        long $lscConfigHash = this.getLscConfigHash();
        result = result * 59 + (int)($lscConfigHash >>> 32 ^ $lscConfigHash);
        List<LogSourceConfigurationDTO> $logSourceConfigurationDTOs = this.getLogSourceConfigurationDTOs();
        result = result * 59 + ($logSourceConfigurationDTOs == null ? 43 : ((Object)$logSourceConfigurationDTOs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AgentSourceConfiguration(disableAllSources=" + this.isDisableAllSources() + ", disableAllLocalSources=" + this.isDisableAllLocalSources() + ", configSyncIntervalMillis=" + this.getConfigSyncIntervalMillis() + ", configSyncIntervalMinMillis=" + this.getConfigSyncIntervalMinMillis() + ", configSyncIntervalMaxMillis=" + this.getConfigSyncIntervalMaxMillis() + ", healthErrorThreshold=" + this.getHealthErrorThreshold() + ", lscConfigHash=" + this.getLscConfigHash() + ", logSourceConfigurationDTOs=" + String.valueOf(this.getLogSourceConfigurationDTOs()) + ")";
    }
}

