/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.log.shared.agent.configurator;

import com.appdynamics.analytics.log.shared.dto.AddFieldConfiguration;
import com.appdynamics.analytics.log.shared.dto.AutoRegexFieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.FieldInfo;
import com.appdynamics.analytics.log.shared.dto.GrokFieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.KeyValueExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.ManualRegexFieldExtractionConfiguration;
import com.appdynamics.analytics.log.shared.dto.MaskConfiguration;
import com.appdynamics.analytics.log.shared.dto.MaskTypeDTO;
import com.appdynamics.analytics.log.shared.dto.MultiLineConfiguration;
import com.appdynamics.analytics.log.shared.dto.RemoveFieldConfiguration;
import com.appdynamics.analytics.log.shared.dto.RenameConfiguration;
import com.appdynamics.analytics.log.shared.dto.TimestampConfiguration;
import com.appdynamics.analytics.log.shared.dto.TimestampFilterConfiguration;
import com.appdynamics.analytics.log.shared.dto.TypeConversionConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineStageConfiguration;
import com.appdynamics.analytics.pipeline.util.FieldValueHelper;
import com.appdynamics.analytics.pipeline.xform.field.FieldMaskingConfiguration;
import com.appdynamics.analytics.pipeline.xform.field.FieldRenameConfiguration;
import com.appdynamics.analytics.pipeline.xform.field.FieldTypeConversionConfiguration;
import com.appdynamics.analytics.pipeline.xform.field.MaskingType;
import com.appdynamics.analytics.pipeline.xform.keyvalue.LogFieldMetadata;
import com.appdynamics.analytics.pipeline.xform.regex.RegexPattern;
import com.appdynamics.common.util.type.ValueType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineStageConfigurationConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineStageConfigurationConverter.class);

    public static PipelineStageConfiguration createMapStageConfiguration() {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:map");
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createMultiLineStageConfiguration(MultiLineConfiguration configuration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("multiline");
        Map properties = pipelineStageConfiguration.getProperties();
        switch (configuration.getMatchType()) {
            case STARTS_WITH: {
                properties.put("startsWith", configuration.getMatchValue());
                break;
            }
            case REGEX: {
                properties.put("regex", configuration.getMatchValue());
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown Match type [%s]", new Object[]{configuration.getMatchType()}));
            }
        }
        properties.put("matchAction", "new");
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createGrokStageConfiguration(GrokFieldExtractionConfiguration configuration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:grok");
        Map properties = pipelineStageConfiguration.getProperties();
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add(configuration.getPattern());
        properties.put("patterns", patterns);
        properties.put("source", configuration.getSource());
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createAutoRegexStageConfiguration(AutoRegexFieldExtractionConfiguration autoRegexFieldExtractionConfiguration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:regex");
        Map properties = pipelineStageConfiguration.getProperties();
        String source = "message";
        ArrayList<RegexPattern> regexPatterns = new ArrayList<RegexPattern>();
        if (autoRegexFieldExtractionConfiguration != null) {
            source = autoRegexFieldExtractionConfiguration.getSource();
            int size = autoRegexFieldExtractionConfiguration.getFields().size();
            String[] alias = new String[size];
            ValueType[] valueType = new ValueType[size];
            int i = 0;
            for (FieldInfo field : autoRegexFieldExtractionConfiguration.getFields()) {
                alias[i] = field.getFieldName();
                valueType[i] = field.getType();
                ++i;
            }
            RegexPattern regexPattern = new RegexPattern(autoRegexFieldExtractionConfiguration.getRegex(), alias, valueType);
            regexPatterns.add(regexPattern);
        }
        properties.put("source", source);
        properties.put("regexPatterns", regexPatterns);
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createManualRegexStageConfiguration(ManualRegexFieldExtractionConfiguration manualRegexFieldExtractionConfiguration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:regex");
        Map properties = pipelineStageConfiguration.getProperties();
        String source = "message";
        ArrayList<RegexPattern> regexPatterns = new ArrayList<RegexPattern>();
        if (manualRegexFieldExtractionConfiguration != null) {
            source = manualRegexFieldExtractionConfiguration.getSource();
            FieldInfo field = manualRegexFieldExtractionConfiguration.getField();
            try {
                RegexPattern regexPattern = new RegexPattern(manualRegexFieldExtractionConfiguration.getRegex(), new String[]{field.getFieldName()}, new ValueType[]{field.getType()});
                regexPatterns.add(regexPattern);
            }
            catch (NullPointerException e) {
                log.error("Error in creating manual regex: [{}] with exception:", (Object)manualRegexFieldExtractionConfiguration, (Object)e);
            }
        }
        properties.put("regexPatterns", regexPatterns);
        properties.put("source", source);
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createKeyValueStageConfiguration(KeyValueExtractionConfiguration configuration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:keyValue");
        Map properties = pipelineStageConfiguration.getProperties();
        ArrayList<String> source = new ArrayList<String>();
        source.add(configuration.getSource());
        properties.put("source", source);
        properties.put("separators", configuration.getSeparators());
        properties.put("splits", configuration.getSplits());
        HashMap<String, LogFieldMetadata> keyToField = new HashMap<String, LogFieldMetadata>();
        if (configuration.getKeyToField() != null) {
            for (Map.Entry<String, FieldInfo> kv : configuration.getKeyToField().entrySet()) {
                FieldInfo logField = kv.getValue();
                keyToField.put(kv.getKey(), new LogFieldMetadata(logField.getFieldName(), logField.getType()));
            }
        }
        properties.put("keyToField", keyToField);
        if (configuration.getTrim() != null) {
            properties.put("trim", configuration.getTrim());
        }
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createRequestGuidStageConfiguration(String accessKey, String source) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:requestGuid");
        Map properties = pipelineStageConfiguration.getProperties();
        properties.put("source", source);
        properties.put("key", accessKey);
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createDateTimeStageConfiguration(TimestampConfiguration configuration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:datetime");
        Map properties = pipelineStageConfiguration.getProperties();
        if (configuration.getTimestampRegexPattern() != null) {
            properties.put("pattern", configuration.getTimestampRegexPattern());
        }
        if (configuration.getTimeZone() != null) {
            properties.put("overrideTimeZone", configuration.getTimeZone());
        }
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createDuplicateTimeCorrectionConfiguration() {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:duplicateTimestampCorrection");
        Map properties = pipelineStageConfiguration.getProperties();
        properties.put("source", "eventTimestamp");
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createTimestampFilterStageConfiguration(TimestampFilterConfiguration configuration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:timestampFilter");
        Map properties = pipelineStageConfiguration.getProperties();
        String source = configuration.getSource() != null ? configuration.getSource() : "eventTimestamp";
        properties.put("source", source);
        properties.put("collectLastNHours", configuration.getCollectLastNHours());
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createAddFieldStageConfiguration(AddFieldConfiguration configuration) {
        Object castedValue;
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:field:add");
        Map properties = pipelineStageConfiguration.getProperties();
        if (configuration != null && (castedValue = FieldValueHelper.cast((String)configuration.getField(), (String)configuration.getValue(), (ValueType)configuration.getValueType())) != null) {
            properties.put(configuration.getField(), castedValue);
        }
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createFieldRestrictionStageConfiguration() {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:fieldRestriction");
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createFieldMaskingStageConfiguration(MaskConfiguration configuration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:field:fieldMasking");
        Map properties = pipelineStageConfiguration.getProperties();
        ArrayList<FieldMaskingConfiguration> maskingConfigurations = new ArrayList<FieldMaskingConfiguration>();
        FieldMaskingConfiguration fieldMaskingConfiguration = new FieldMaskingConfiguration(PipelineStageConfigurationConverter.convertToMaskType(configuration.getMaskType()), configuration.getField(), configuration.getReplaceString(), configuration.getStartIndex(), configuration.getEndIndex());
        maskingConfigurations.add(fieldMaskingConfiguration);
        properties.put("maskFields", maskingConfigurations);
        return pipelineStageConfiguration;
    }

    private static MaskingType convertToMaskType(MaskTypeDTO maskType) {
        if (maskType == null) {
            return null;
        }
        switch (maskType) {
            case REPEAT: {
                return MaskingType.REPEAT;
            }
            case REPLACE: {
                return MaskingType.REPLACE;
            }
        }
        return null;
    }

    public static PipelineStageConfiguration createFieldRenameStageConfiguration(RenameConfiguration configuration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:field:rename");
        Map properties = pipelineStageConfiguration.getProperties();
        ArrayList<FieldRenameConfiguration> renameConfigurations = new ArrayList<FieldRenameConfiguration>();
        FieldRenameConfiguration fieldRenameConfiguration = new FieldRenameConfiguration(configuration.getField(), configuration.getNewField());
        renameConfigurations.add(fieldRenameConfiguration);
        properties.put("fields", renameConfigurations);
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createFieldTypeConversionStageConfiguration(TypeConversionConfiguration configuration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:field:typeConversion");
        Map properties = pipelineStageConfiguration.getProperties();
        ArrayList<FieldTypeConversionConfiguration> fieldTypeConversionConfiguration = new ArrayList<FieldTypeConversionConfiguration>();
        FieldTypeConversionConfiguration typeConversionConfiguration = new FieldTypeConversionConfiguration(configuration.getField(), configuration.getType(), configuration.getFormat());
        fieldTypeConversionConfiguration.add(typeConversionConfiguration);
        properties.put("fields", fieldTypeConversionConfiguration);
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createMap2JsonStageConfiguration(boolean clearMaps) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:json:map2Json");
        Map properties = pipelineStageConfiguration.getProperties();
        properties.put("clearMaps", clearMaps);
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createTapStageConfiguration(String queueName) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("tap");
        Map properties = pipelineStageConfiguration.getProperties();
        properties.put("queueName", queueName);
        return pipelineStageConfiguration;
    }

    public static PipelineStageConfiguration createFieldRemovalStage(RemoveFieldConfiguration configuration) {
        PipelineStageConfiguration pipelineStageConfiguration = new PipelineStageConfiguration();
        pipelineStageConfiguration.setUri("xform:field:removal");
        Map properties = pipelineStageConfiguration.getProperties();
        if (configuration != null) {
            ArrayList<String> removeFields = new ArrayList<String>();
            removeFields.add(configuration.getField());
            properties.put("fields", removeFields);
        }
        return pipelineStageConfiguration;
    }

    @Generated
    private PipelineStageConfigurationConverter() {
    }
}

