#!/bin/bash

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
DOCKER_REGISTRY=829771730735.dkr.ecr.us-west-2.amazonaws.com
LATEST_TAG=latest
TEMP_TAG=temptag
MACHINE_AGENT_ROOT_DIR=${PWD}
MACHINE_AGENT_DIST_DIR=${MACHINE_AGENT_ROOT_DIR}/dist
MACHINE_AGENT_REPO_NAME=$DOCKER_REGISTRY/appdynamics/machine-agent
INFRA_BUNDLE_REPO_NAME=$DOCKER_REGISTRY/sim/infra-agent-bundle
MACHINE_AGENT_ZIP=machine-agent.zip
CONTEXT_DIR=""
REPO_NAME=""

#
# @param Repository to remove
#
function removeImages() {
  # Remove images.
  docker image ls | grep "^$REPO_NAME" | awk '{ print "docker image rm -f " $3 }' | bash
}

#
# @param Repo name, and tag name.
#
function publishImages() {
    #If build number is available, push one image by tagging with build number
    if [ ! -z "$BUILD_NUMBER" ]; then
        docker tag $REPO_NAME:$TEMP_TAG $REPO_NAME:$BUILD_NUMBER
        docker push $REPO_NAME:$BUILD_NUMBER
    fi

    #one image for the latest in branch
    # BASE_VERSION is defined in the Makefile
    if [ -n "$BASE_VERSION" ]; then
        docker tag $REPO_NAME:$TEMP_TAG $REPO_NAME:$BASE_VERSION-$LATEST_TAG
        docker push $REPO_NAME:$BASE_VERSION-$LATEST_TAG
    fi

    #if master push one just as latest
    # BUILD_REF_NAME comes from teamcity, for master branch its value is master
    # and for 4.4.next branch its value is "release/4.4.next"
    if [ -n "$BUILD_REF_NAME" ] && [ "$BUILD_REF_NAME" == "master" ]; then
        docker tag $REPO_NAME:$TEMP_TAG $REPO_NAME:$LATEST_TAG
        docker push $REPO_NAME:$LATEST_TAG
    fi
}

function createContextDirectory() {
    # creating a temporary directory context for docker
    CONTEXT_DIR=$DIR/context

    rm -rf $CONTEXT_DIR
    mkdir -p $CONTEXT_DIR
}

function copyResources() {
    local TYPE=$1
    local ARTIFACT=$2
    # Copying machine-agent.zip, Dockerfile and start-appdynamics to the staging directory.
    cp $MACHINE_AGENT_DIST_DIR/$ARTIFACT $CONTEXT_DIR/$MACHINE_AGENT_ZIP
    cp $DIR/start-appdynamics $CONTEXT_DIR
    if [ "${TYPE}" = "Machine" ]; then
        cp $DIR/Dockerfile $CONTEXT_DIR
    elif [ "${TYPE}" = "Infra" ]; then
        cp $DIR/IADockerfile $CONTEXT_DIR/Dockerfile
    fi
}

function dockerLogin() {
    printenv DOCKER_PASSWORD \
      | docker login --username "${DOCKER_USERNAME}" \
                     --password-stdin \
                     "${DOCKER_REGISTRY}"
}

function dockerBuild() {
    docker build -t $REPO_NAME:$TEMP_TAG $CONTEXT_DIR
}

function printCreatedImages() {
    printf '\nCreated these images:\n'
    docker images | grep -e $REPO_NAME
}

function removeContextDirectory() {
    rm -rf $CONTEXT_DIR
}

function publish() {
    local TYPE=$1
    local ARTIFACT=$2

    if [ "${TYPE}" = "Machine" ]; then
        REPO_NAME=$MACHINE_AGENT_REPO_NAME
    elif [ "${TYPE}" = "Infra" ]; then
        REPO_NAME=$INFRA_BUNDLE_REPO_NAME
    else
        echo "Unknown Type"
        exit 1
    fi

    createContextDirectory
    copyResources "$TYPE" "$ARTIFACT"
    dockerLogin
    removeImages
    dockerBuild
    publishImages
    removeContextDirectory
    printCreatedImages
}

"$@";
