/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.util;

import com.singularity.ee.agent.systemagent.task.util.TaskWriter;
import com.singularity.ee.task.ArgumentMetaData;
import com.singularity.ee.task.ExecTaskMetaData;
import com.singularity.ee.task.ExecTaskType;
import com.singularity.ee.task.JavaTaskMetaData;
import com.singularity.ee.task.LogMessageVerifierData;
import com.singularity.ee.task.LogMessageVerifierSource;
import com.singularity.ee.task.TaskMetaData;
import com.singularity.ee.task.VerifierData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskCreator {
    private static PrintStream out = System.out;
    private static BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    private final Logger logger = LogManager.getLogger(TaskCreator.class);

    public void println(String str) {
        out.println(str);
    }

    private String getInput(String prompt) throws IOException {
        return this.getInput(prompt, false);
    }

    private String getInput(String prompt, boolean acceptEmpty) throws IOException {
        out.print("\n" + prompt + ":> ");
        String input = reader.readLine();
        while (input != null) {
            try {
                if (!input.trim().equals("")) {
                    return input;
                }
                if (acceptEmpty) {
                    return "";
                }
                out.print("\n" + prompt + ":> ");
            }
            catch (Throwable t) {
                this.logger.error("Error while reading file: {}", (Object)t.getMessage());
            }
            input = reader.readLine();
        }
        return "";
    }

    public void getTaskDetails() throws Exception {
        TaskWriter writer;
        TaskMetaData taskMetaData;
        boolean isJava = true;
        String taskName = this.getInput("Enter Name for the Task");
        String taskType = this.getInput("Enter type of task -   ['e'] for executable/ 'j' for java", true);
        if (taskType.equals("") || taskType.equals("e")) {
            taskMetaData = new ExecTaskMetaData();
            isJava = false;
        } else {
            taskMetaData = new JavaTaskMetaData();
        }
        taskMetaData.setName(taskName);
        this.getTaskTimeOut(taskMetaData);
        this.getOutputCaptureData(taskMetaData);
        this.addTaskArguments(taskMetaData);
        if (isJava) {
            this.addJavaTaskDetails((JavaTaskMetaData)taskMetaData);
            this.addVerifierDetails(taskMetaData);
            writer = new TaskWriter((JavaTaskMetaData)taskMetaData);
        } else {
            this.addExecutableTaskDetails((ExecTaskMetaData)taskMetaData);
            this.addVerifierDetails(taskMetaData);
            writer = new TaskWriter((ExecTaskMetaData)taskMetaData);
        }
        writer.saveTaskDefinitionToFile("/Users/bhaskar/work/task.xml");
    }

    private void getTaskTimeOut(TaskMetaData taskMetaData) throws Exception {
        String execTimeOut = this.getInput("Enter Task Execution Timeout in seconds, Press Enter for Default value of [300 seconds]", true);
        if (!execTimeOut.equals("")) {
            try {
                int timeOut = Integer.parseInt(execTimeOut);
                taskMetaData.setExecutionTimeOutInSeconds(timeOut);
            }
            catch (NumberFormatException e) {
                out.print("Invalid Task Execution Timeout Specified [" + execTimeOut + "], using default value");
                taskMetaData.setExecutionTimeOutInSeconds(300);
            }
        } else {
            taskMetaData.setExecutionTimeOutInSeconds(300);
        }
    }

    private void getOutputCaptureData(TaskMetaData taskMetaData) throws Exception {
        String enableOutputStr = this.getInput("Do you want to capture output from the task [y]/n", true);
        if (enableOutputStr.equalsIgnoreCase("y") || enableOutputStr.equals("")) {
            taskMetaData.setOutputCaptureEnabled(true);
            String outputCaptureTimeout = this.getInput("Enter Task Output Capture Timeout in seconds, Press Enter for Default value of [120 seconds]", true);
            if (!outputCaptureTimeout.equals("")) {
                try {
                    int timeOut = Integer.parseInt(outputCaptureTimeout);
                    taskMetaData.setOutputCaptureTimePeriod(timeOut);
                }
                catch (NumberFormatException e) {
                    out.print("Invalid Task Output capture timeout Specified [" + outputCaptureTimeout + "], using default value");
                    taskMetaData.setExecutionTimeOutInSeconds(120);
                }
            } else {
                taskMetaData.setExecutionTimeOutInSeconds(120);
            }
        } else {
            taskMetaData.setOutputCaptureEnabled(false);
        }
    }

    private void addTaskArguments(TaskMetaData taskMetaData) throws Exception {
        block3: {
            String addAnother;
            String hasArguments = this.getInput("Does your task have any arguments ? [y]/n", true);
            if (!hasArguments.equalsIgnoreCase("y") && !hasArguments.equals("")) break block3;
            ArrayList<ArgumentMetaData> argMetaDataList = new ArrayList<ArgumentMetaData>();
            out.println("Add Task Arguments ");
            do {
                String argumentName = this.getInput("Enter Argument Name");
                String isRequiredStr = this.getInput("Is this a required argument ? [y]/n", true);
                boolean isRequired = false;
                if (isRequiredStr.equalsIgnoreCase("y") || isRequiredStr.equals("")) {
                    isRequired = true;
                }
                String defaultValueStr = this.getInput("Does this argument have a default value ? Press Enter if it does not have a default value", true);
                String defaultValue = null;
                if (!defaultValueStr.equals("")) {
                    defaultValue = defaultValueStr;
                }
                ArgumentMetaData argMetaData = new ArgumentMetaData(argumentName, isRequired, defaultValue);
                argMetaDataList.add(argMetaData);
            } while (!(addAnother = this.getInput("Add Another Argument ? [y]/n", true)).equalsIgnoreCase("n"));
            taskMetaData.setArgsMetaData(argMetaDataList);
        }
    }

    private void addExecutableTaskDetails(ExecTaskMetaData taskMetaData) throws Exception {
        String processExit;
        String multiFiles;
        String executableTaskType = this.getInput("Enter type of executable task -   ['f'] for file / 'c for command", true);
        boolean isScript = true;
        if (executableTaskType.equalsIgnoreCase("c")) {
            isScript = false;
            taskMetaData.setExecTaskType(ExecTaskType.COMMAND);
        } else {
            taskMetaData.setExecTaskType(ExecTaskType.FILE);
        }
        String scriptPrompt = "Enter Path of File to be executed, relative to the task root directory";
        if (!isScript) {
            scriptPrompt = "Enter Command to be executed";
        }
        if ((multiFiles = this.getInput("Do you want to use different scripts for different Operating Systems [y]/n")).equalsIgnoreCase("y") || multiFiles.equals("")) {
            String addAnother;
            HashMap<String, String> scriptMap = new HashMap<String, String>();
            do {
                String fileName = this.getInput(scriptPrompt);
                String osName = this.getInput("Enter OS for File Name");
                scriptMap.put(osName, fileName);
            } while (!(addAnother = this.getInput("Add for Another OS ? [y]/n", true)).equalsIgnoreCase("n"));
            taskMetaData.setScriptMap(scriptMap);
        } else {
            String fileName = this.getInput(scriptPrompt);
            if (isScript) {
                taskMetaData.setFilePath(fileName);
            } else {
                taskMetaData.setCommandName(fileName);
            }
        }
        String workingDir = this.getInput("Enter Working Directory for the task,This can be relative to the task directory.                                               \nPress Enter to use the task directory as the working directory", true);
        if (!workingDir.equals("")) {
            taskMetaData.setWorkingDir(workingDir);
        }
        if ((processExit = this.getInput("Should the process started by executing the script/command exit before reporting execution feedback? [y]/n", true)).equalsIgnoreCase("y") || processExit.equals("")) {
            taskMetaData.setWaitForProcessExit(true);
        } else {
            taskMetaData.setWaitForProcessExit(false);
        }
    }

    private void addJavaTaskDetails(JavaTaskMetaData javaTaskData) throws Exception {
        String implClass = this.getInput("Get Implementation Class Name for Java Task");
        javaTaskData.setImplementationClassName(implClass);
        String classPath = this.getInput("Enter path separated Classpath string for Java Task, the entries can be relative to the task root directory");
        javaTaskData.setClasspath(classPath);
        String loadJarsFromDirs = this.getInput("Load Jars in directories specified? [y]/n", true);
        if (loadJarsFromDirs.equalsIgnoreCase("y") || loadJarsFromDirs.equals("")) {
            javaTaskData.setLoadJarsInClassPathDirs(true);
        } else {
            javaTaskData.setLoadJarsInClassPathDirs(false);
        }
    }

    private void addVerifierDetails(TaskMetaData taskMetaData) throws Exception {
        String enableVerifier = this.getInput("Enable Task Verification? [y]/n", true);
        if (enableVerifier.equalsIgnoreCase("y") || enableVerifier.equals("")) {
            String failureExpression;
            taskMetaData.setVerifierEnabled(true);
            LogMessageVerifierData verifierData = new LogMessageVerifierData();
            taskMetaData.setVerifierData(verifierData);
            this.addVerifierTimeOut(verifierData);
            String source = this.getInput("Enter the source for verification - '1' for File, '2' for stdout and '3' for stderr");
            if (source.equals("1")) {
                verifierData.setSource(LogMessageVerifierSource.FILE);
                String filePath = this.getInput("Enter file path for verification, this path can be relative to the task working directory");
                verifierData.setFilePath(filePath);
            } else if (source.equals("3")) {
                verifierData.setSource(LogMessageVerifierSource.STDERR);
            } else {
                verifierData.setSource(LogMessageVerifierSource.STDOUT);
            }
            String successExpression = this.getInput("Enter Regular Expression to verify success of task,Press Enter to skip", true);
            if (!successExpression.equals("")) {
                verifierData.setSuccessExpression(successExpression);
            }
            if (!(failureExpression = this.getInput("Enter Regular Expression to verify failure of task,Press Enter to skip", true)).equals("")) {
                verifierData.setFailureExpression(failureExpression);
            }
        } else {
            taskMetaData.setVerifierEnabled(false);
        }
    }

    private void addVerifierTimeOut(VerifierData verifierData) throws Exception {
        String verificationTimeout = this.getInput("Enter Verification Timeout in seconds, Press Enter for Default value of [120 seconds]", true);
        if (!verificationTimeout.equals("")) {
            try {
                int timeOut = Integer.parseInt(verificationTimeout);
                verifierData.setTimeoutInSecs(timeOut);
            }
            catch (NumberFormatException e) {
                out.print("Invalid Task Verification Timeout Specified [" + verificationTimeout + "], using default value");
                verifierData.setTimeoutInSecs(120);
            }
        } else {
            verifierData.setTimeoutInSecs(120);
        }
    }

    public static void main(String[] args) throws Exception {
        TaskCreator cr = new TaskCreator();
        cr.getTaskDetails();
    }
}

