/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.util;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.IMetricAggregatorFactory;
import com.singularity.ee.agent.systemagent.api.ISelfManagedTask;
import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.TaskOutput;
import com.singularity.ee.agent.systemagent.api.exception.TaskExecutionException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorDelegate;
import com.singularity.ee.util.loader.FileSystemClassLoader;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InProcessLauncherTask
implements ISelfManagedTask {
    public static final String ARG_CLASS_NAME = "className";
    public static final String ARG_METHOD_NAME = "methodName";
    public static final String ARG_OPT_CSV_METHOD_ARGS = "csvMethodArgs";
    public static final String PROP_USER_DIR = "user.dir";
    public static final String PROP_APPLICATION_HOME = "APPLICATION_HOME";
    private static final Logger logger = LogManager.getLogger((String)InProcessLauncherTask.class.getName());
    private ClassLoader classLoader;
    private String workingDirectory;
    private Object optionalInstance;

    @Override
    public void setClassLoader(FileSystemClassLoader externalLoader) {
        File libDir = null;
        String[] paths = externalLoader.getClassPath();
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            File file = new File(paths[i]);
            if (file.isDirectory()) {
                if (libDir == null || libDir.getAbsolutePath().length() > file.getAbsolutePath().length()) {
                    libDir = file;
                }
                logger.info("Found a directory [" + libDir.getAbsolutePath() + "]");
            }
            try {
                urls[i] = file.toURI().toURL();
                logger.debug("ClassPath URL [" + urls[i].toString() + "]");
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("An error occurred while attempting to create a classpath using the parameters provided", e);
            }
        }
        if (this.workingDirectory == null && libDir != null && libDir.getParentFile() != null) {
            this.workingDirectory = libDir.getParentFile().getAbsolutePath();
            logger.info("Working directory appears to be [" + this.workingDirectory + "]");
        }
        this.classLoader = new URLClassLoader(urls, null);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setWorkingDirectory(String path) {
        this.workingDirectory = path;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void init(IMetricAggregatorFactory metricFactory, IAgentScheduledExecutorService scheduler, ManagedMonitorDelegate managedMonitorDelegate) {
    }

    @Override
    public TaskOutput execute(Map<String, String> taskArguments, TaskExecutionContext taskContext) throws TaskExecutionException {
        logger.info("Starting to execute actual task with parameters [" + String.valueOf(taskArguments) + "]");
        String className = taskArguments.get(ARG_CLASS_NAME);
        String methodName = taskArguments.get(ARG_METHOD_NAME);
        String csvMethodArgs = taskArguments.get(ARG_OPT_CSV_METHOD_ARGS);
        if (className == null) {
            String s = "The mandatory task argument [className] is absent";
            logger.error(s);
            throw new TaskExecutionException(s);
        }
        if (methodName == null) {
            String s = "The mandatory task argument [methodName] is absent";
            logger.error(s);
            throw new TaskExecutionException(s);
        }
        String[] methodArgs = new String[]{};
        if (csvMethodArgs != null) {
            methodArgs = csvMethodArgs.split(",");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        String wd = this.getWorkingDirectory();
        String oldUserDir = System.getProperty(PROP_USER_DIR);
        String oldAppHome = System.getProperty(PROP_APPLICATION_HOME);
        if (wd != null) {
            System.setProperty(PROP_USER_DIR, wd);
            System.setProperty(PROP_APPLICATION_HOME, wd);
        }
        try {
            this.launch(className, methodName, methodArgs);
        }
        catch (Throwable t) {
            String msg = "Error occurred while attempting to load the task [" + String.valueOf(taskArguments) + "]";
            logger.fatal(msg, t);
            throw new TaskExecutionException(msg, t);
        }
        finally {
            if (oldUserDir != null) {
                System.setProperty(PROP_USER_DIR, oldUserDir);
            }
            if (oldAppHome != null) {
                System.setProperty(PROP_APPLICATION_HOME, oldAppHome);
            }
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        return new TaskOutput("Success");
    }

    private void launch(String className, String methodName, String[] methodArgs) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> actualClass = Class.forName(className, true, this.classLoader);
        Method actualMethod = null;
        if (methodArgs.length == 0) {
            logger.debug("No method arguments have been provided, so it will be assumed that the method [" + methodName + "] does not take any arguments");
            actualMethod = actualClass.getDeclaredMethod(methodName, new Class[0]);
        } else {
            logger.debug("The following method arguments will be used " + String.valueOf(Arrays.asList(methodArgs)));
            actualMethod = actualClass.getDeclaredMethod(methodName, String[].class);
        }
        if (Modifier.isStatic(actualMethod.getModifiers())) {
            logger.debug("The method [" + String.valueOf(actualMethod) + "] appears to be a static method");
            actualMethod.invoke(null, new Object[]{methodArgs});
        } else {
            logger.debug("The method [" + String.valueOf(actualMethod) + "] appears to be an instance method, so an instance of the class [" + actualClass.getName() + "] will be created");
            this.optionalInstance = actualClass.newInstance();
            logger.debug("Created an instance of [" + actualClass.getName() + "] - [" + String.valueOf(this.optionalInstance) + "]");
            actualMethod.invoke(this.optionalInstance, new Object[]{methodArgs});
        }
        logger.info("Started [" + actualClass.getName() + "]");
    }

    @Override
    public void stop() {
        this.optionalInstance = null;
        this.classLoader = null;
        logger.info("Stopped");
    }
}

