/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.util;

import com.singularity.ee.rest.RESTResponse;
import com.singularity.ee.rest.controller.request.TaskExecutionStatusRequest;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentTaskHandler {
    private static final Logger logger = LogManager.getLogger((String)AgentTaskHandler.class.getName());
    private static final Log4JLogger iLogger = new Log4JLogger(logger);
    private String tasksRootDir;
    private String controllerHost;
    private int controllerPort;
    private String machineInstanceID;

    public AgentTaskHandler(String tasksRootDir, String controllerHost, int controllerPort, String machineInstanceID) {
        this.tasksRootDir = tasksRootDir;
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.machineInstanceID = machineInstanceID;
    }

    public void handleTaskGetRequest(String uri, HttpServletResponse response) throws IOException {
        try {
            String taskName = this.getTaskName(uri);
            TaskExecutionStatusRequest req = new TaskExecutionStatusRequest(this.controllerHost, this.controllerPort, this.machineInstanceID, "", iLogger);
            req.setTaskStarted();
            req.setOutput("Found Task [" + taskName + "]");
            if (new File(this.getTaskDir(taskName)).exists()) {
                req.setExists(true);
            } else {
                req.setExists(false);
            }
            req.writeToResponse(response);
        }
        catch (Exception e) {
            RESTResponse.sendFailureResponse((HttpServletResponse)response, (String)("Invalid URI to get task" + uri), (ILogger)iLogger);
            return;
        }
    }

    public String getTaskName(String uri) {
        return uri.substring(uri.lastIndexOf("/") + 1, uri.length());
    }

    public String getTaskDir(String taskName) {
        return this.tasksRootDir + File.separator + taskName;
    }
}

