/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.sigar;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.IMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.agent.systemagent.task.sigar.AggGroup;
import com.singularity.ee.agent.systemagent.task.sigar.DiffReporter;
import com.singularity.ee.agent.systemagent.task.sigar.SigarMinuteTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkAgg
extends AggGroup {
    static final String NET_INCOMING_KB = "Incoming KB";
    static final String NET_INCOMING_KB_RATE = "Incoming KB/sec";
    static final String NET_OUTGOING_KB = "Outgoing KB";
    static final String NET_OUTGOING_KB_RATE = "Outgoing KB/sec";
    static final String NET_INCOMING_PACKETS_KB = "Incoming packets";
    static final String NET_INCOMING_PACKETS_KB_RATE = "Incoming packets/sec";
    static final String NET_OUTGOING_PACKETS_KB = "Outgoing packets";
    static final String NET_OUTGOING_PACKETS_KB_RATE = "Outgoing packets/sec";
    private IMetricAggregatorFactory metricFactory;
    private DiffReporter incomingBytesReporter = null;
    private DiffReporter outgoingBytesReporter = null;
    private DiffReporter incomingPacketsReporter = null;
    private DiffReporter outgoingPacketsReporter = null;
    private static Logger logger = LogManager.getLogger((String)NetworkAgg.class.getName());

    public NetworkAgg(String networkName, IMetricAggregatorFactory metricFactory) {
        super("Network");
        this.metricFactory = metricFactory;
        try {
            IMetricAggregator incomingBytes = this.metricFactory.safeGetAggregator(SigarMinuteTask.getMI(this.getMN(networkName, NET_INCOMING_KB), MetricAggregatorType.OBSERVATION));
            IMetricAggregator incomingBytesPerSec = this.metricFactory.safeGetAggregator(SigarMinuteTask.getMI(this.getMN(networkName, NET_INCOMING_KB_RATE), MetricAggregatorType.OBSERVATION));
            IMetricAggregator outgoingBytes = this.metricFactory.safeGetAggregator(SigarMinuteTask.getMI(this.getMN(networkName, NET_OUTGOING_KB), MetricAggregatorType.OBSERVATION));
            IMetricAggregator outgoingBytesPerSec = this.metricFactory.safeGetAggregator(SigarMinuteTask.getMI(this.getMN(networkName, NET_OUTGOING_KB_RATE), MetricAggregatorType.OBSERVATION));
            IMetricAggregator incomingPackets = this.metricFactory.safeGetAggregator(SigarMinuteTask.getMI(this.getMN(networkName, NET_INCOMING_PACKETS_KB), MetricAggregatorType.OBSERVATION));
            IMetricAggregator incomingPacketsPerSec = this.metricFactory.safeGetAggregator(SigarMinuteTask.getMI(this.getMN(networkName, NET_INCOMING_PACKETS_KB_RATE), MetricAggregatorType.OBSERVATION));
            IMetricAggregator outgoingPackets = this.metricFactory.safeGetAggregator(SigarMinuteTask.getMI(this.getMN(networkName, NET_OUTGOING_PACKETS_KB), MetricAggregatorType.OBSERVATION));
            IMetricAggregator outgoingPacketsPerSec = this.metricFactory.safeGetAggregator(SigarMinuteTask.getMI(this.getMN(networkName, NET_OUTGOING_PACKETS_KB_RATE), MetricAggregatorType.OBSERVATION));
            this.incomingBytesReporter = new DiffReporter(incomingBytes, incomingBytesPerSec);
            this.outgoingBytesReporter = new DiffReporter(outgoingBytes, outgoingBytesPerSec);
            this.outgoingPacketsReporter = new DiffReporter(outgoingPackets, outgoingPacketsPerSec);
            this.incomingPacketsReporter = new DiffReporter(incomingPackets, incomingPacketsPerSec);
        }
        catch (MetricOverflowException | MetricReporterTypeMismatchException e) {
            logger.error("Exception occurred in metric reporter: {}", (Object)e.getMessage());
        }
    }

    public DiffReporter getIncomingBytesReporter() {
        return this.incomingBytesReporter;
    }

    public DiffReporter getOutgoingBytesReporter() {
        return this.outgoingBytesReporter;
    }

    public DiffReporter getIncomingPacketsReporter() {
        return this.incomingPacketsReporter;
    }

    public DiffReporter getOutgoingPacketsReporter() {
        return this.outgoingPacketsReporter;
    }
}

