/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.sigar;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.IMetricReporter;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.agent.systemagent.task.sigar.AggGroup;
import com.singularity.ee.agent.systemagent.task.sigar.LastData;
import com.singularity.ee.agent.systemagent.task.sigar.SigarMinuteTask;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOPSReporter
extends AggGroup {
    private static final String IOPS_USE_PERC = "% CPU Time";
    private static final String IOPS_SERVICE_TIME = "Avg Service Time (ms)";
    private static final String IOPS_QUEUE_TIME = "Avg Queue Time (ms)";
    private SigarMinuteTask task;
    private IMetricAggregator diskUsagePercentageAgg;
    private IMetricAggregator diskServiceTimeAgg;
    private IMetricReporter diskQueueTimeAgg;
    private LastData lastData = null;
    private final Logger logger = LogManager.getLogger(IOPSReporter.class);

    public IOPSReporter(String diskName, SigarMinuteTask task) {
        super("Disks");
        this.task = task;
        try {
            this.diskUsagePercentageAgg = this.task.getMetricFactory().safeGetAggregator(SigarMinuteTask.getMI(this.getMN(diskName, IOPS_USE_PERC), MetricAggregatorType.OBSERVATION));
            this.diskServiceTimeAgg = this.task.getMetricFactory().safeGetAggregator(SigarMinuteTask.getMI(this.getMN(diskName, IOPS_SERVICE_TIME), MetricAggregatorType.OBSERVATION));
            this.diskQueueTimeAgg = this.task.getMetricFactory().safeGetAggregator(SigarMinuteTask.getMI(this.getMN(diskName, IOPS_QUEUE_TIME), MetricAggregatorType.OBSERVATION));
        }
        catch (MetricOverflowException | MetricReporterTypeMismatchException e) {
            this.logger.error("Exception occurred in metric reporter: {}", (Object)e.getMessage());
        }
    }

    public void report(long diskReads, long diskWrites, double diskServiceTime, double diskQueue) {
        if (this.task.getLogger().getLevel() == Level.TRACE) {
            this.task.getLogger().trace("[diskReads, diskWrites, diskServiceTime, diskQueue]=[" + diskReads + ", " + diskWrites + ", " + diskServiceTime + ", " + diskQueue + "]");
        }
        if (this.lastData != null) {
            long interval = (System.currentTimeMillis() - this.lastData.timestamp) / 1000L;
            long usagePercentage = IOPSReporter.calculateUsagePercentage(this.lastData, this.task.getLogger(), diskReads, diskWrites, diskServiceTime, interval);
            this.diskUsagePercentageAgg.report(usagePercentage);
            if (diskServiceTime > 0.0) {
                this.diskServiceTimeAgg.report((long)diskServiceTime);
            }
            if (diskQueue > 0.0) {
                this.diskQueueTimeAgg.report((long)diskQueue);
            }
        } else {
            IOPSReporter.calculateUsagePercentage(this.lastData, this.task.getLogger(), diskReads, diskWrites, diskServiceTime, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateUsagePercentage(LastData lastData, Logger logger, long diskReads, long diskWrites, double diskServiceTime, long interval) {
        try {
            long usage = 0L;
            if (lastData != null && interval != 0L && diskReads > 0L && diskWrites > 0L && diskServiceTime > 0.0 && interval > 0L) {
                double diskReadsPerSec = (double)(diskReads - lastData.diskReads) * 1.0 / (double)interval;
                double diskWritesPerSec = (double)(diskWrites - lastData.diskWrites) * 1.0 / (double)interval;
                usage = Math.round((diskReadsPerSec + diskWritesPerSec) * diskServiceTime / 10.0);
                if (logger.isDebugEnabled()) {
                    logger.debug("iostat : " + interval + " " + diskReadsPerSec + " " + diskWritesPerSec + " " + diskServiceTime + " " + usage + "%");
                }
            }
            long l = usage;
            return l;
        }
        finally {
            lastData = new LastData();
            lastData.diskReads = diskReads;
            lastData.diskWrites = diskWrites;
            lastData.timestamp = System.currentTimeMillis();
        }
    }
}

