/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.sigar;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.agent.systemagent.task.sigar.AggGroup;
import com.singularity.ee.agent.systemagent.task.sigar.FactorAndDeltaReporter;
import com.singularity.ee.agent.systemagent.task.sigar.IOPSReporter;
import com.singularity.ee.agent.systemagent.task.sigar.SigarMinuteTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DiskAgg
extends AggGroup {
    static final String DISK_READ_KB_RATE = "KB read/sec";
    static final String DISK_WRITE_KB_RATE = "KB written/sec";
    static final String DISK_READS_RATE = "Reads/sec";
    static final String DISK_WRITES_RATE = "Writes/sec";
    private IMetricAggregator spaceAvailable;
    private IMetricAggregator spaceUsed;
    private FactorAndDeltaReporter readBytesReporter;
    private FactorAndDeltaReporter writeBytesReporter;
    private FactorAndDeltaReporter readCountReporter;
    private FactorAndDeltaReporter writeCountReporter;
    private IOPSReporter iopsReporter;
    private static Logger logger = LogManager.getLogger((String)DiskAgg.class.getName());

    DiskAgg(String diskName, SigarMinuteTask task) {
        super("Disks");
        try {
            this.spaceAvailable = task.getMetricFactory().safeGetAggregator(SigarMinuteTask.getMI(this.getMN(diskName, "Space Available"), MetricAggregatorType.OBSERVATION));
            this.spaceUsed = task.getMetricFactory().safeGetAggregator(SigarMinuteTask.getMI(this.getMN(diskName, "Space Used"), MetricAggregatorType.OBSERVATION));
            IMetricAggregator readBytes = task.getMetricFactory().safeGetAggregator(SigarMinuteTask.getMI(this.getMN(diskName, DISK_READ_KB_RATE), MetricAggregatorType.OBSERVATION));
            IMetricAggregator writeBytes = task.getMetricFactory().safeGetAggregator(SigarMinuteTask.getMI(this.getMN(diskName, DISK_WRITE_KB_RATE), MetricAggregatorType.OBSERVATION));
            IMetricAggregator readCount = task.getMetricFactory().safeGetAggregator(SigarMinuteTask.getMI(this.getMN(diskName, DISK_READS_RATE), MetricAggregatorType.OBSERVATION));
            IMetricAggregator writeCount = task.getMetricFactory().safeGetAggregator(SigarMinuteTask.getMI(this.getMN(diskName, DISK_WRITES_RATE), MetricAggregatorType.OBSERVATION));
            this.readBytesReporter = new FactorAndDeltaReporter(readBytes, 1024);
            this.writeBytesReporter = new FactorAndDeltaReporter(writeBytes, 1024);
            this.readCountReporter = new FactorAndDeltaReporter(readCount, 1);
            this.writeCountReporter = new FactorAndDeltaReporter(writeCount, 1);
            this.iopsReporter = new IOPSReporter(diskName, task);
        }
        catch (MetricOverflowException | MetricReporterTypeMismatchException e) {
            logger.error("Exception occurred in metric reporter: {}", (Object)e.getMessage());
        }
    }

    IMetricAggregator getSpaceAvailable() {
        return this.spaceAvailable;
    }

    IMetricAggregator getSpaceUsed() {
        return this.spaceUsed;
    }

    FactorAndDeltaReporter getReadBytesReporter() {
        return this.readBytesReporter;
    }

    FactorAndDeltaReporter getWriteBytesReporter() {
        return this.writeBytesReporter;
    }

    FactorAndDeltaReporter getReadCountReporter() {
        return this.readCountReporter;
    }

    FactorAndDeltaReporter getWriteCountReporter() {
        return this.writeCountReporter;
    }

    IOPSReporter getIopsReporter() {
        return this.iopsReporter;
    }
}

