/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.sigar;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;

public class DiffReporter {
    private long lastValue = -1L;
    private long lastTimeStamp = -1L;
    private final IMetricAggregator agg;
    private final IMetricAggregator deltaAgg;

    public DiffReporter(IMetricAggregator agg, IMetricAggregator deltaAgg) {
        this.agg = agg;
        this.deltaAgg = deltaAgg;
    }

    public long report(long value) {
        long valuePerSec = 0L;
        if (this.lastValue != -1L) {
            long timeInSeconds = (System.currentTimeMillis() - this.lastTimeStamp) / 1000L;
            valuePerSec = (long)((double)(value - this.lastValue) * 1.0 / (double)timeInSeconds);
            this.deltaAgg.report(valuePerSec);
            this.agg.report(value - this.lastValue);
        }
        this.lastValue = value;
        this.lastTimeStamp = System.currentTimeMillis();
        return valuePerSec;
    }

    public IMetricAggregator getAgg() {
        return this.agg;
    }

    public IMetricAggregator getDeltaAgg() {
        return this.deltaAgg;
    }
}

