/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.classloading;

import com.appdynamics.agent.sim.configuration.bootstrap.AgentHomeDir;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.singularity.ee.agent.systemagent.task.classloading.SystemLibs;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MonitorsSharedLibrariesClassLoader
extends URLClassLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorsSharedLibrariesClassLoader.class);
    private static final URL[] EMPTY_CLASSPATH = new URL[0];
    @VisibleForTesting
    static final String LEGACY_LIB_REL_PATH = "monitorsLibs";

    @Inject
    MonitorsSharedLibrariesClassLoader(@AgentHomeDir String agentHomePath, @SystemLibs ClassLoader parentClassLoader) {
        super(MonitorsSharedLibrariesClassLoader.buildClasspath(agentHomePath), parentClassLoader.getParent());
    }

    @VisibleForTesting
    static URL[] buildClasspath(String agentHomePath) {
        File extensionLibsDir = new File(agentHomePath, LEGACY_LIB_REL_PATH);
        if (!extensionLibsDir.isDirectory() || !extensionLibsDir.canRead()) {
            log.warn("Could not read directory {} for extension libraries. Extensions may not work correctly.", (Object)extensionLibsDir);
            return EMPTY_CLASSPATH;
        }
        File[] files = extensionLibsDir.listFiles();
        if (files == null) {
            log.warn("Could not list the files under {} for extension libraries. Extensions may not work correctly.", (Object)extensionLibsDir);
            return EMPTY_CLASSPATH;
        }
        ArrayList<URL> extLibClasspath = new ArrayList<URL>();
        for (File file : files) {
            try {
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                extLibClasspath.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                assert (false);
                log.warn("Could not get URL from file path {} to add to library classpath. Skipping.", (Object)file);
            }
        }
        return extLibClasspath.toArray(new URL[extLibClasspath.size()]);
    }
}

