/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.apache;

import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.task.apache.ATomcatWorkersConfigTask;
import com.singularity.ee.agent.systemagent.task.apache.ApacheWorkersConfigHandler;
import java.util.Map;

public class AddTomcatWorkerTask
extends ATomcatWorkersConfigTask {
    public static final String WORKER_HOSTS = "worker-hosts";
    public static final String WORKER_PORT = "worker-port";
    public static final String WORKER_LBFACTOR = "worker-lbfactor";

    @Override
    protected void doTomcatWorkersConfig(Map<String, String> taskArguments, TaskExecutionContext taskContext, ApacheWorkersConfigHandler handler) throws Exception {
        String hostNamesInput = taskArguments.get(WORKER_HOSTS);
        String[] hostNames = hostNamesInput.split(",");
        String port = taskArguments.get(WORKER_PORT);
        String lbFactor = taskArguments.get(WORKER_LBFACTOR);
        if (lbFactor == null || lbFactor.trim().length() == 0) {
            lbFactor = "1";
        }
        for (String host : hostNames) {
            handler.addWorkerToLB(this.getWorkerName(host, port), host, port, lbFactor);
        }
    }

    protected String getWorkerName(String host, String port) {
        String workerName = host.replace(".", "_") + "_" + port.replace(".", "_");
        return workerName;
    }
}

