/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task.analytics;

import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.TaskOutput;
import com.singularity.ee.agent.systemagent.api.exception.TaskExecutionException;
import com.singularity.ee.agent.systemagent.task.util.InProcessLauncherTask;
import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalyticsAgentLauncher
extends InProcessLauncherTask {
    private static final Logger logger = LogManager.getLogger((String)AnalyticsAgentLauncher.class.getName());
    private static final String ANALYTICS_MAIN_CLASS = "com.appdynamics.analytics.agent.AnalyticsAgent";
    private static final String ANALYTICS_MAIN_METHOD = "main";
    private static final String ANALYTICS_RELATIVE_PATH_PROPERTIES = File.separator + "conf" + File.separator + "analytics-agent.properties";
    private static final String ANALYTICS_RELATIVE_PATH_LOGS = File.separator + ".." + File.separator + ".." + File.separator + "logs";
    private static final String ANALYTICS_PROPERTY_LOG_DIR = "ad.dw.log.path";
    private static final String ANALYTICS_MODE_EMBEDDED = "analytics.mode.embedded";

    @Override
    public TaskOutput execute(Map<String, String> taskArguments, TaskExecutionContext taskContext) throws TaskExecutionException {
        if (taskArguments.isEmpty()) {
            String wd = this.getWorkingDirectory();
            if (wd == null) {
                throw new IllegalArgumentException("A valid working directory path has to be provided");
            }
            taskArguments.put("className", ANALYTICS_MAIN_CLASS);
            taskArguments.put("methodName", ANALYTICS_MAIN_METHOD);
            String propertiesPath = wd + ANALYTICS_RELATIVE_PATH_PROPERTIES;
            taskArguments.put("csvMethodArgs", propertiesPath);
            Object logsDir = System.getProperty("appdynamics.agent.logs.dir");
            if (logsDir == null) {
                logsDir = wd + ANALYTICS_RELATIVE_PATH_LOGS;
            }
            System.setProperty(ANALYTICS_PROPERTY_LOG_DIR, (String)logsDir);
            logger.info("The logs directory property [ad.dw.log.path] has been set to [" + (String)logsDir + "]");
            System.setProperty(ANALYTICS_MODE_EMBEDDED, "true");
        }
        return super.execute(taskArguments, taskContext);
    }
}

