/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.agent.systemagent.api.IOutputPropertyGatherer;
import com.singularity.ee.agent.systemagent.api.IStreamConsumer;
import com.singularity.ee.agent.systemagent.task.ControllerUtil;
import com.singularity.ee.agent.systemagent.task.ITimeout;
import com.singularity.ee.controller.api.constants.TaskExecutionStatus;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Verifier
implements IStreamConsumer,
ITimeout {
    private static Logger logger = LogManager.getLogger((String)Verifier.class.getName());
    private String taskID;
    private ControllerUtil controllerUtil;
    private Pattern successPattern;
    private Pattern failurePattern;
    private boolean isActive = true;
    private final IOutputPropertyGatherer outputPropertyGatherer;

    public Verifier(String taskID, String successExpr, String failureExpr, ControllerUtil controllerUtil, IOutputPropertyGatherer outputPropertyGatherer) {
        this.taskID = taskID;
        this.controllerUtil = controllerUtil;
        this.outputPropertyGatherer = outputPropertyGatherer;
        if (successExpr != null) {
            this.successPattern = Pattern.compile(successExpr);
        }
        if (failureExpr != null) {
            this.failurePattern = Pattern.compile(failureExpr);
        }
        logger.info("Setup Verifier for task id [" + taskID + "] with success expression [" + successExpr + "] failure expression [" + failureExpr + "]");
    }

    @Override
    public void consumeLine(String line) {
        Matcher failureMatcher;
        Matcher successMatcher;
        if (this.successPattern != null && (successMatcher = this.successPattern.matcher(line)).find()) {
            logger.debug("Verifier Matched successs line pattern " + line);
            logger.debug("Sending Success verification status to controller for taskID [" + this.taskID + "]");
            this.controllerUtil.sendExecutionStatus(this.taskID, "Task Verified Successfully", TaskExecutionStatus.SUCCESSFUL, true, this.outputPropertyGatherer.getProperties());
            this.isActive = false;
        }
        if (this.failurePattern != null && (failureMatcher = this.failurePattern.matcher(line)).find()) {
            logger.debug("Verifier Matched failure line pattern " + line);
            logger.debug("Sending failure verification status to controller for taskID [" + this.taskID + "]");
            this.controllerUtil.sendExecutionStatus(this.taskID, "Task Verification failed", TaskExecutionStatus.FAILED, true, null);
            this.isActive = false;
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void timeOut(long currentTime) {
        if (this.isActive) {
            logger.info("Task with ID [" + this.taskID + "] verification timedout.");
            this.controllerUtil.sendExecutionStatus(this.taskID, "Task Verification Timedout.", TaskExecutionStatus.TIMEDOUT, true, null);
        }
        this.isActive = false;
    }
}

