/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.agent.systemagent.api.AJavaTask;
import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.ITaskVerifier;
import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.exception.TaskInstantiationException;
import com.singularity.ee.agent.systemagent.task.ControllerUtil;
import com.singularity.ee.agent.systemagent.task.ExecTask;
import com.singularity.ee.agent.systemagent.task.JavaTaskCreator;
import com.singularity.ee.agent.systemagent.task.LogFileReaderRunnable;
import com.singularity.ee.agent.systemagent.task.OutputGatherer;
import com.singularity.ee.agent.systemagent.task.OutputPropertyGatherer;
import com.singularity.ee.agent.systemagent.task.StreamReaderRunnable;
import com.singularity.ee.agent.systemagent.task.TaskExecuterRunnable;
import com.singularity.ee.agent.systemagent.task.TaskThreadPools;
import com.singularity.ee.agent.systemagent.task.TimeoutTask;
import com.singularity.ee.agent.systemagent.task.Verifier;
import com.singularity.ee.task.ArgumentMetaData;
import com.singularity.ee.task.CustomVerifierData;
import com.singularity.ee.task.ExecTaskMetaData;
import com.singularity.ee.task.InvalidTaskMetaDataException;
import com.singularity.ee.task.JavaTaskMetaData;
import com.singularity.ee.task.LogMessageVerifierData;
import com.singularity.ee.task.LogMessageVerifierSource;
import com.singularity.ee.task.TaskMetaData;
import com.singularity.ee.task.TaskReader;
import com.singularity.ee.task.TaskType;
import com.singularity.ee.task.VerifierType;
import com.singularity.ee.util.io.PathResolver;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.loader.FileSystemClassLoader;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskRunner {
    public static final String TASK_XML = "task.xml";
    private String taskName;
    private Map<String, String> taskArguments;
    private String controlChannelDir;
    private ControllerUtil controllerUtil;
    private String taskID;
    private TaskMetaData taskMetaData;
    private String taskWorkingDir;
    private FileSystemClassLoader loader;
    private OutputGatherer outputGatherer;
    private OutputGatherer errGatherer;
    private TaskExecuterRunnable taskExecuter;
    private static Logger logger = LogManager.getLogger((String)TaskRunner.class.getName());
    private IAgentScheduledExecutorService scheduler;
    private final OutputPropertyGatherer outputPropertyGatherer;

    public TaskRunner(String taskID, String controlChannelDir, String taskName, Map<String, String> taskArguments, IAgentScheduledExecutorService scheduler, ControllerUtil controllerUtil, Set<String> outputPropertyNames) {
        this.taskID = taskID;
        this.taskName = taskName;
        this.taskArguments = taskArguments;
        this.controlChannelDir = controlChannelDir;
        this.controllerUtil = controllerUtil;
        this.scheduler = scheduler;
        this.outputPropertyGatherer = new OutputPropertyGatherer(outputPropertyNames);
        if (outputPropertyNames == null || outputPropertyNames.isEmpty()) {
            this.outputPropertyGatherer.deactivate();
        }
    }

    public void runTask() throws InvalidTaskMetaDataException, TaskInstantiationException {
        logger.info("Running task [" + this.taskName + "]");
        this.taskMetaData = this.getMetaDataForTask();
        boolean javaTask = this.taskMetaData.getTaskType().equals((Object)TaskType.JAVA);
        logger.debug("Obtained task meta data for task [" + String.valueOf(this.taskMetaData) + "]");
        this.combineTaskArguments(this.taskArguments);
        ITask task = this.createTask();
        logger.info("Final Task Arguments " + String.valueOf(this.taskArguments));
        TaskExecutionContext context = new TaskExecutionContext();
        context.setTaskDir(this.taskMetaData.getTaskDir());
        this.taskExecuter = new TaskExecuterRunnable(task, this.taskID, this.taskArguments, context, this.taskMetaData.getExecutionTimeOutInSeconds(), this.controllerUtil, this.scheduler, this.taskMetaData.isVerifierEnabled(), this.outputPropertyGatherer);
        if (javaTask) {
            this.setupReadersForJavaTask(task);
            context.setAdditionalClasspathEntries(this.loader.getClassPath());
        } else {
            this.setupReadersForExecTask((ExecTask)task);
        }
        this.taskExecuter.setCustomVerifier(this.getCustomVerifier());
        this.taskExecuter.setOutputGatherer(this.outputGatherer);
        this.taskExecuter.setErrGatherer(this.errGatherer);
        TaskThreadPools.getTaskThreadPool().execute((Runnable)((Object)this.taskExecuter));
    }

    private void setupReadersForJavaTask(ITask task) throws TaskInstantiationException {
        if (!(task instanceof AJavaTask)) {
            throw new TaskInstantiationException("Task of type java does not extend from AJavaTask");
        }
        AJavaTask javaTask = (AJavaTask)task;
        if (this.taskMetaData.isOutputCaptureEnabled()) {
            this.outputGatherer = new OutputGatherer(this.taskID, "stdout", this.controllerUtil, this.scheduler);
            this.errGatherer = new OutputGatherer(this.taskID, "stderr", this.controllerUtil, this.scheduler);
            logger.debug("Setup stdout gatherer and stderr gatherer ########################### ");
            javaTask.addOutStreamConsumer(this.outputGatherer);
            javaTask.addErrStreamConsumer(this.errGatherer);
            TimeoutTask timeoutTask = new TimeoutTask(this.outputGatherer);
            long timeout = this.getOutputCaptureTimeout(this.taskMetaData);
            this.scheduler.schedule((IAgentRunnable)timeoutTask, timeout, AgentTimeUnit.MILLISECONDS);
            logger.debug("Setup output capture for time [" + timeout / 1000L + "] seconds");
        }
        if (this.taskMetaData.isVerifierEnabled()) {
            if (this.taskMetaData.getVerifierData().getVerifierType().equals((Object)VerifierType.LOG_MESSAGE_VERIFIER)) {
                Runnable verifierRunnable = this.setupLogMessageVerifier(javaTask);
                if (verifierRunnable != null) {
                    TaskThreadPools.getVerifierThreadPool().execute(verifierRunnable);
                }
            } else {
                throw new RuntimeException("Custom verifier not supported ");
            }
        }
        javaTask.setOutputPropertyGatherer(this.outputPropertyGatherer);
    }

    private ITaskVerifier getCustomVerifier() throws TaskInstantiationException {
        if (this.taskMetaData.getVerifierData() == null) {
            return null;
        }
        if (this.taskMetaData.getVerifierData().getVerifierType().equals((Object)VerifierType.CUSTOM_VERIFIER)) {
            return this.createCustomVerifier((CustomVerifierData)this.taskMetaData.getVerifierData());
        }
        return null;
    }

    private void setupReadersForExecTask(ExecTask task) {
        Runnable verifierRunnable;
        StreamReaderRunnable outputStreamReader = new StreamReaderRunnable(task.getOutputReader());
        StreamReaderRunnable errorStreamReader = new StreamReaderRunnable(task.getErrorReader());
        if (this.taskMetaData.isOutputCaptureEnabled()) {
            this.setOutputCapture(outputStreamReader, errorStreamReader);
        }
        if (this.taskMetaData.isVerifierEnabled() && this.taskMetaData.getVerifierData().getVerifierType().equals((Object)VerifierType.LOG_MESSAGE_VERIFIER) && (verifierRunnable = this.setupLogMessageVerifier(outputStreamReader, errorStreamReader)) != null) {
            TaskThreadPools.getVerifierThreadPool().execute(verifierRunnable);
        }
        if (!((ExecTaskMetaData)this.taskMetaData).isWaitForProcessExit()) {
            this.taskExecuter.setStopOutputCaptureWhenTaskExits(false);
        }
        outputStreamReader.addStreamConsumer(this.outputPropertyGatherer);
        ScheduledFuture<?> outputCaptureFuture = TaskThreadPools.getOutputCaptureThreadPool().scheduleWithFixedDelay(outputStreamReader, 100L, 100L, TimeUnit.MILLISECONDS);
        ScheduledFuture<?> errorCaptureFuture = TaskThreadPools.getOutputCaptureThreadPool().scheduleWithFixedDelay(errorStreamReader, 100L, 100L, TimeUnit.MILLISECONDS);
        this.taskExecuter.addOutputCaptureSchedule(outputCaptureFuture);
        this.taskExecuter.addOutputCaptureSchedule(errorCaptureFuture);
    }

    private TaskMetaData getMetaDataForTask() throws InvalidTaskMetaDataException, TaskInstantiationException {
        File taskDir = new File(this.controlChannelDir + File.separator + this.taskName);
        if (!taskDir.exists()) {
            throw new TaskInstantiationException("Could not find directory for task[" + this.taskName + "]");
        }
        File taskDataFile = new File(this.controlChannelDir + File.separator + this.taskName + File.separator + TASK_XML);
        if (!taskDataFile.exists()) {
            throw new TaskInstantiationException("Could not find task.xml in directory for task[" + this.taskName + "]");
        }
        TaskReader taskReader = new TaskReader();
        TaskMetaData metaData = taskReader.readTaskFromFile(taskDir.getAbsolutePath(), taskDataFile);
        if (logger.isDebugEnabled()) {
            logger.debug("Task meta data read [" + String.valueOf(metaData) + "]");
        }
        return metaData;
    }

    private ITask createTask() throws TaskInstantiationException {
        if (this.taskMetaData.getTaskType().equals((Object)TaskType.EXECUTABLE)) {
            ExecTaskMetaData execData = (ExecTaskMetaData)this.taskMetaData;
            this.taskWorkingDir = this.resolveWorkingDirForExecTask(execData.getWorkingDir()).getAbsolutePath();
            return new ExecTask(execData, this.taskArguments, this.taskWorkingDir);
        }
        if (this.taskMetaData.getTaskType().equals((Object)TaskType.JAVA)) {
            JavaTaskMetaData javaTaskData = (JavaTaskMetaData)this.taskMetaData;
            JavaTaskCreator javaTaskCreator = new JavaTaskCreator(javaTaskData);
            ITask task = javaTaskCreator.createJavaTask();
            this.loader = javaTaskCreator.getLoader();
            return task;
        }
        throw new TaskInstantiationException("Invalid Task Type in task meta data " + String.valueOf(this.taskMetaData));
    }

    private void setOutputCapture(StreamReaderRunnable outputStreamReader, StreamReaderRunnable errorStreamReader) {
        this.outputGatherer = new OutputGatherer(this.taskID, "stdout", this.controllerUtil, this.scheduler);
        this.errGatherer = new OutputGatherer(this.taskID, "stderr", this.controllerUtil, this.scheduler);
        outputStreamReader.addStreamConsumer(this.outputGatherer);
        errorStreamReader.addStreamConsumer(this.errGatherer);
        TimeoutTask timerTask = new TimeoutTask(this.outputGatherer);
        long timeout = this.getOutputCaptureTimeout(this.taskMetaData);
        this.scheduler.schedule((IAgentRunnable)timerTask, timeout, AgentTimeUnit.MILLISECONDS);
        logger.debug("Setup output capture for time [" + timeout / 1000L + "] seconds");
    }

    private Runnable setupLogMessageVerifier(StreamReaderRunnable outputStreamReader, StreamReaderRunnable errorStreamReader) {
        LogMessageVerifierData logMessageVerifierData = (LogMessageVerifierData)this.taskMetaData.getVerifierData();
        LogMessageVerifierSource source = logMessageVerifierData.getSource();
        String successExpression = this.replaceArgumentTokenIfExists(logMessageVerifierData.getSuccessExpression());
        String failureExpression = this.replaceArgumentTokenIfExists(logMessageVerifierData.getFailureExpression());
        Verifier verifier = new Verifier(this.taskID, successExpression, failureExpression, this.controllerUtil, this.outputPropertyGatherer);
        if (source.equals((Object)LogMessageVerifierSource.STDOUT) || source.equals((Object)LogMessageVerifierSource.STDERR)) {
            if (source.equals((Object)LogMessageVerifierSource.STDOUT)) {
                outputStreamReader.addStreamConsumer(verifier);
            } else {
                errorStreamReader.addStreamConsumer(verifier);
            }
            TimeoutTask timerTask = new TimeoutTask(verifier);
            this.scheduler.schedule((IAgentRunnable)timerTask, this.getVerifierTimeout(this.taskMetaData), AgentTimeUnit.MILLISECONDS);
            return null;
        }
        if (logMessageVerifierData.getSource().equals((Object)LogMessageVerifierSource.FILE)) {
            File logFile = PathResolver.getResolvedFileOnDisk((String)this.taskWorkingDir, (String)this.replaceArgumentTokenIfExists(logMessageVerifierData.getFilePath()));
            logger.info("Resolved log file: " + String.valueOf(logFile));
            LogFileReaderRunnable logRunnable = new LogFileReaderRunnable(logFile.getAbsolutePath());
            logRunnable.addStreamConsumer(verifier);
            return logRunnable;
        }
        return null;
    }

    private Runnable setupLogMessageVerifier(AJavaTask javaTask) {
        logger.info("Setting up log message verifier");
        LogMessageVerifierData logMessageVerifierData = (LogMessageVerifierData)this.taskMetaData.getVerifierData();
        LogMessageVerifierSource source = logMessageVerifierData.getSource();
        logger.info("Setting up log message verifier source -" + String.valueOf((Object)source));
        Verifier verifier = new Verifier(this.taskID, this.replaceArgumentTokenIfExists(logMessageVerifierData.getSuccessExpression()), this.replaceArgumentTokenIfExists(logMessageVerifierData.getFailureExpression()), this.controllerUtil, this.outputPropertyGatherer);
        if (source.equals((Object)LogMessageVerifierSource.STDOUT) || source.equals((Object)LogMessageVerifierSource.STDERR)) {
            if (source.equals((Object)LogMessageVerifierSource.STDOUT)) {
                javaTask.addOutStreamConsumer(verifier);
            } else {
                javaTask.addErrStreamConsumer(verifier);
            }
            TimeoutTask timerTask = new TimeoutTask(verifier);
            this.scheduler.schedule((IAgentRunnable)timerTask, this.getVerifierTimeout(this.taskMetaData), AgentTimeUnit.MILLISECONDS);
            return null;
        }
        if (logMessageVerifierData.getSource().equals((Object)LogMessageVerifierSource.FILE)) {
            File logFile = PathResolver.getResolvedFileOnDisk((String)this.taskMetaData.getTaskDir(), (String)this.replaceArgumentTokenIfExists(logMessageVerifierData.getFilePath()));
            logger.info("Resolved log file: " + String.valueOf(logFile));
            LogFileReaderRunnable logRunnable = new LogFileReaderRunnable(logFile.getAbsolutePath());
            logRunnable.addStreamConsumer(verifier);
            return logRunnable;
        }
        return null;
    }

    private void combineTaskArguments(Map<String, String> taskArguments) throws TaskInstantiationException {
        List<ArgumentMetaData> argsMetaDataList = this.taskMetaData.getArgsMetaData();
        logger.info("Arg meta data list: " + String.valueOf(argsMetaDataList));
        for (ArgumentMetaData argumentMetaData : argsMetaDataList) {
            if (taskArguments.get(argumentMetaData.getName()) != null) continue;
            logger.info(argumentMetaData.getName() + " Value ->" + taskArguments.get(argumentMetaData.getName()));
            if ((argumentMetaData.getDefaultValue() == null || "".equals(argumentMetaData.getDefaultValue())) && argumentMetaData.isRequired()) {
                throw new TaskInstantiationException("Required Task Argument [" + argumentMetaData.getName() + "] does not have a value, cannot run task");
            }
            logger.info("Adding to task arguments: " + argumentMetaData.getName() + "-->" + argumentMetaData.getDefaultValue());
            taskArguments.put(argumentMetaData.getName(), argumentMetaData.getDefaultValue());
        }
    }

    public ITaskVerifier createCustomVerifier(CustomVerifierData verifierData) throws TaskInstantiationException {
        String verifierClassPath = verifierData.getClasspath();
        String taskWorkingDir = this.taskMetaData.getTaskDir();
        String javaMainClass = verifierData.getImplementationClassName();
        logger.debug("Verifier Data Read ClassPath [" + verifierClassPath + "] Working Dir [" + taskWorkingDir + "] Main Class [" + javaMainClass + "]");
        FileSystemClassLoader loader = new FileSystemClassLoader((ILogger)new Log4JLogger(logger));
        try {
            loader.parseAndAddClassPath(verifierClassPath, verifierData.isLoadJarsInClassPathDirs(), taskWorkingDir, true);
        }
        catch (IOException e) {
            logger.error("Error setting up classpath for Custom Verifier [" + this.taskMetaData.getName() + "]", (Throwable)e);
            throw new TaskInstantiationException("Could not add classpath entries for verifier [" + this.taskMetaData.getName() + "]");
        }
        try {
            Class verifierClass = loader.loadClass(javaMainClass);
            return (ITaskVerifier)verifierClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error("Error loading Main class for Custom Verifier [" + this.taskMetaData.getName() + "]", (Throwable)e);
            throw new TaskInstantiationException("Could not load Custom Verifier [" + javaMainClass + "] for task [" + this.taskMetaData.getName() + "]");
        }
        catch (ClassCastException e) {
            logger.error("Custom Verifier  class for task [" + this.taskMetaData.getName() + "] does not implement the ITaskVerifier interface", (Throwable)e);
            throw new TaskInstantiationException("Custom Verifier  class for task  [" + this.taskMetaData.getName() + "] does not implement the ITaskVerifier interface");
        }
        catch (Throwable e) {
            logger.error("Could not load/instantiate the Custom Verifier Main class for task [" + this.taskMetaData.getName() + "]", e);
            throw new TaskInstantiationException("Could not load/instantiate the Custom Verifier main class[" + javaMainClass + "] for task [" + this.taskMetaData.getName() + "]");
        }
    }

    private String replaceArgumentTokenIfExists(String valueRead) {
        if (valueRead == null) {
            return null;
        }
        String resolvedValue = valueRead;
        for (String argumentName : this.taskArguments.keySet()) {
            if (resolvedValue.indexOf(argumentName) <= 0) continue;
            resolvedValue = resolvedValue.replace("$" + argumentName, this.taskArguments.get(argumentName));
            logger.debug("Original ###### " + valueRead);
            logger.debug("Resolved #### " + resolvedValue);
        }
        logger.debug("resolved verifier data" + resolvedValue);
        return resolvedValue;
    }

    private File resolveWorkingDirForExecTask(String workingDir) throws TaskInstantiationException {
        if (workingDir == null || workingDir.equals("")) {
            workingDir = this.taskMetaData.getTaskDir();
        } else {
            try {
                logger.debug("Resolving working directory  [" + workingDir + "]");
                workingDir = PathResolver.getResolvedAndValidatedPathOnDisk((String)this.taskMetaData.getTaskDir(), (String)workingDir);
            }
            catch (IOException e) {
                logger.error("Cannot resolve working directory on disk[" + workingDir + "], cannot instantiate task [" + this.taskMetaData.getName() + "]", (Throwable)e);
                throw new TaskInstantiationException("Cannot resolve working directory to a path on disk[" + workingDir + "]");
            }
        }
        File workingDirFile = new File(workingDir);
        logger.trace("Process working dir resolved" + workingDir);
        return workingDirFile;
    }

    private long getOutputCaptureTimeout(TaskMetaData metaData) {
        int valueRead = metaData.getOutputCaptureTimePeriod();
        long timeout = valueRead == -1 ? 120000L : (long)(valueRead * 1000);
        return timeout;
    }

    private long getVerifierTimeout(TaskMetaData metaData) {
        int valueRead = metaData.getVerifierData().getTimeoutInSecs();
        long timeout = valueRead == -1 ? 120000L : (long)(valueRead * 1000);
        return timeout;
    }
}

