/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.agent.systemagent.api.IStreamConsumer;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamReaderRunnable
implements Runnable {
    private Logger logger = LogManager.getLogger((String)StreamReaderRunnable.class.getName());
    private final BufferedReader reader;
    private final List<IStreamConsumer> consumerList = Collections.synchronizedList(new ArrayList());

    public StreamReaderRunnable(BufferedReader reader) {
        this.reader = reader;
    }

    public void addStreamConsumer(IStreamConsumer consumer) {
        this.consumerList.add(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<IStreamConsumer> finalConsumerList;
        List<IStreamConsumer> list = this.consumerList;
        synchronized (list) {
            finalConsumerList = new ArrayList<IStreamConsumer>(this.consumerList);
        }
        if (this.hasActiveConsumers(finalConsumerList)) {
            try {
                while (this.reader.ready()) {
                    String line = this.reader.readLine();
                    if (line == null) continue;
                    this.logger.trace("intermediate read from stream " + line);
                    this.feedActiveConsumers(line, finalConsumerList);
                }
            }
            catch (Throwable e) {
                this.logger.error("Error reading stream", e);
            }
        }
    }

    private void feedActiveConsumers(String line, List<IStreamConsumer> consumerList) {
        Iterator<IStreamConsumer> iter = consumerList.iterator();
        while (iter.hasNext()) {
            IStreamConsumer consumer = iter.next();
            if (!consumer.isActive()) {
                iter.remove();
                continue;
            }
            consumer.consumeLine(line);
        }
    }

    private boolean hasActiveConsumers(List<IStreamConsumer> consumerList) {
        for (IStreamConsumer consumer : consumerList) {
            if (!consumer.isActive()) continue;
            return true;
        }
        return false;
    }

    public void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            this.logger.trace("Error sleeping in stream reader", (Throwable)e);
        }
    }
}

